#include <stdio.h>
#include <time.h>
#include <stdlib.h>

#define SCALARPART	0.2
#define PROMPT		"IBIG> "
#define CLOCKS_PER_SEC	1000000

FLOAT v[SIZE], w[SIZE], x[SIZE];


/* ibig
 * This programs purpose is to test the systems ability to handle
 * big interactive programs.
 * We are not interrested in a high Mflop rate here.
 * The two arrays w and x are added into array v.
 *
 * Ensure the your compiler/system does NOT vectorize the loops in the
 * scalar() routine and that is does vectorize in the vector() routine
 *
 * Purpose of these two routines is to access all declared memory as
 * fast as possible.
 */

prompt()
{
	fputs(PROMPT, stdout);
	fflush(stdout);
}

FLOAT scalar(nrep)
long nrep;
{
	long i, j, k;
	FLOAT zz;

	zz = 0.0;
	for(j=0; j<nrep; j++) {
		k = SIZE;
		for(i=0; i<SIZE; i++) {
			zz = w[i] + x[--k];
		}
	}
	return zz;
}

vector(nrep)
long nrep;
{
	long i, j;

	for(j=0; j<nrep; j++) {
		for(i=0; i<SIZE; i++) {
			v[i] = w[i] + x[i];
		}
	}
}

main()
{
	long i, nrep;
	FLOAT zz;
	long c1, c2, c3;

	if( sizeof(FLOAT) != 8 ) {
		fprintf(stderr, "Floating point variable is not 64 bits\n");
		exit(1);
	}

	for(i=0; i<SIZE; i++) {
		w[i] = 1.0 / ( i + 1 );
		x[i] = 1.0 / ( i + 2 );
	}
	prompt();
	while(scanf("%ld", &nrep) == 1 && nrep > 0) {
		c1 = clock();
		zz = scalar((long) ((FLOAT)nrep * SCALARPART) );
		c2 = clock();
		vector((long) ((FLOAT)nrep * (1.0 - SCALARPART)) );
		c3 = clock();
		printf("Size        : %ld\n", SIZE);
		if( c2 == c1 )
			c2 = c1 + 1;
		if( c3 == c2 )
			c3 = c2 + 1;
		printf("Scalar speed: %8.3f Mflops\n",
			1000000.0 *
			(float)nrep * SCALARPART * SIZE /
			((float) (c2-c1) * CLOCKS_PER_SEC) );
		printf("Vector speed: %8.3f Mflops\n",
			1000000.0 *
			(float)nrep * (1.0 - SCALARPART) * SIZE /
			((float) (c3-c2) * CLOCKS_PER_SEC) );
		prompt();
	}
}
