      Subroutine genraja( na, ja, ra, m, n, lamax, lua, luna, lral )
! --------------------------------------------------------------------
      Use         numerics
      Implicit    None

      Integer  :: lamax, lua, luna, lral, m, n
      Integer  :: ja(lamax), na(lamax)
      Real(l_) :: ra(lamax)
! --------------------------------------------------------------------
! --- Local constants and variables ...

      Real(l_), Parameter :: one = 1.0_l_
      Real(l_)            :: dran1
      Integer             :: i, idum, j, l , lra, nra

! --------------------------------------------------------------------
! --- Routine 'genraja' generates the arrays  'ra' and 'ja'. As in
!     the case of 'na' the arrays are never entirely in core and are
!     written in chunks of length 'lamax' to unit 'lua'.

      Read( luna ) ( na(i), i = 1, n )
      Do i = 1, n
         lra = lral + na(i) - 1
         If ( lra <= lamax ) Then
            Do l = lral, lra
               ra(l) = one
               ja(l) = Min( m, Int( m*dran1( idum ) ) + 1 )
            End Do
            lral = lra + 1
         Else
            nra  = lra/lamax
            lra  = Mod( lra, lamax )
            Do l = lral, lamax
               ra(l) = one
               ja(l) = Min( m, Int( m*dran1( idum ) ) + 1 )
            End Do
            Write ( lua ) ra, ja
            Do j = 1, nra - 1
               Do l = 1, lamax
                  ra(l) = one
                  ja(l) = Min( m, Int( m*dran1( idum ) ) + 1 )
               End Do
               Write ( lua ) ra, ja
            End Do
            Do l = 1, lra
               ra(l) = one
               ja(l) = Min( m, Int( m*dran1( idum ) ) + 1 )
            End Do
            lral = lra + 1
         End If
      End Do
 
      Write ( lua ) ra, ja 
! --------------------------------------------------------------------
      End Subroutine genraja

