      Subroutine ranint( low, hi, n, ranint_array )
! ---------------------------------------------------------------------
! --- Routine 'ranint' generates an random array of 'n' integers with 
!     values in the range [low, hi]. When [low, hi] = [1,n], 
!     'ranint_array' is not neccesarily a permutation, i.e., 
!      ranint_array(i) might be equal to ranint_array(j) for some i, j.
! ---------------------------------------------------------------------
      Implicit                              None
      Integer, Intent(in)                :: low, hi, n
      Integer, Dimension(n), Intent(out) :: ranint_array
      Real, Dimension(n)                 :: dummy(n)
! ---------------------------------------------------------------------
      Call random_number( dummy )
      ranint_array = Int( ( hi - low + 1)*dummy + low )
! ---------------------------------------------------------------------
      End Subroutine ranint
