      Program mod2i
! ---------------------------------------------------------------------
!     Program 'mod2i' tests an iterative Quicksort algorithm with 
!     Integer and 8-byte Real data. Data are generated internally
!     by the Fortran 90-provided random generator.
! ---------------------------------------------------------------------
      Use                       numerics
      Implicit                  None

      Interface qsort
      ! --- Integer sort
      Subroutine iqsort( idata, n, nl, nu )
      Integer, Intent( in )  :: n, nl, nu
      Integer, Intent( Inout) :: idata(n)

      End Subroutine iqsort
      ! --- 8-byte Real sort
      Subroutine dqsort( ddata, n, nl, nu )
      Use numerics
      Integer, Intent( in )  :: n, nl, nu
      Real(l_), Intent( Inout) :: ddata(n)
      End Subroutine dqsort
      End Interface
     
      Integer, Allocatable   :: idata(:), src(:)
      Real(l_),  Allocatable :: ddata(:)
      Real(l_)               :: speed1, speed2, time1, time2, wclock, 
     &                          cor, dlog2
      Integer                :: i, n, nops, nrep
      Logical                :: ok1, ok2
      External               :: dlog2
! ---------------------------------------------------------------------
      Call state( 'mod2i   ' )
      Open( 1, File = 'mod2i.in' )
      Print 1000
   10 Read( 1, *, End = 20 ) n, nrep
      Allocate( idata(n), ddata(n), src(n) )
      Call ranint( 1, n, n, src )
      nops  = Int( n*dlog2( n ) )         ! --- Average work estimate!!

      time1 = wclock()                    ! --- Integer sort.
      Do i = 1, nrep
         idata = src
         Call qsort( idata, n, 1, n )
      End Do
      time1 = wclock() - time1
      time2 = wclock()                    ! --- 8-byte Real sort.
      Do i = 1, nrep
         ddata = Real( src, l_ )
         Call qsort( ddata, n, 1, n )
      End Do
      time2 = wclock() - time2

      ok1 = .TRUE.
      ok2 = .TRUE.
      Call icheck( idata, n, ok1 )        ! --- Correctness checks.
      Call dcheck( ddata, n, ok2 )

      cor = wclock()                      ! --- Correct timings.
      Do i = 1, nrep
         idata = src
      End Do
      time1 = time1 - wclock() + cor
      cor = wclock()
      Do i = 1, nrep
         ddata = Real( src, l_ )
      End Do
      time2 = time2 - wclock() + cor
      
      speed1 = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time1, 1.0e-9_l_ )
      speed2 = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time2, 1.0e-9_l_ )
      Print 1010, n, time1/nrep, speed1, ok1, time2/nrep, speed2, ok2  
      Deallocate( idata, ddata , src )
      Go To 10
   20 Print 1020
! ---------------------------------------------------------------------
 1000 Format( 'Quicksort test:'/
     &        '-------------------------------------------------------',
     &        '----------------'/,
     &        '  Order |  Integer   |  Integer  |     |   Double   |',
     &        '  Double   |     |'/,
     &        '    n   |  Time (s)  |  (Mop/s)  | OK? |  Time (s)  |',
     &        '  (Mop/s)  | OK? |'/,
     &        '-------------------------------------------------------',
     &        '----------------' )
 1010 Format( I7,' |', G11.4,' |', G11.4, '|', L3,'  |', G11.4,
     &        ' |', G11.4, '|', L3, '  |' )
 1020 Format( '-------------------------------------------------------',
     &        '----------------' )
c ----------------------------------------------------------------------
      End Program mod2i
