      Subroutine gendat( a, n1, n2 )
! ---------------------------------------------------------------------
! --- Routine 'gendat' generates the data to be used in a 2-D Haar
!     wavelet transform.
! ---------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: n1, n2
      Real(l_) :: a(n1,n2)

      Integer  :: i1, i2
! ---------------------------------------------------------------------
      Do i2 = 1, n2
         Do i1 = 1, n1
            a(i1,i2) = ( (i2 - 1)*1.0_l_*n1 + i1 )
         End Do
      End Do
! ---------------------------------------------------------------------
      End Subroutine gendat      
