      Subroutine check( a, w, n1, n2, ok )
! ---------------------------------------------------------------------
! --- Routine 'check' checks the correctness of a 2-D Haar wavelet 
!     followed by the synthesis on the result array 'a'. This should
!     be identical to the original ('w').
! ---------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: n1, n2
      Real(l_) :: a(n1,n2), w(n1,n2)
      Logical  :: ok

      Integer  :: i, j
      Real(l_) :: eps
! ---------------------------------------------------------------------
      eps = 4.0_l_*Epsilon( 1.0_l_ )
      Do j = 1, n2
         Do i = 1, n1
            ok = ok .AND. ( Abs( a(i,j) - w(i,j) ) < eps )
         End Do
      End Do
! ---------------------------------------------------------------------
      End Subroutine check
