      Subroutine makmat( a, n )
! ----------------------------------------------------------------------
      Use      numerics
      Implicit None
! ----------------------------------------------------------------------
! --- This subroutines generates a symmetric matrix A. Only the lower
!     triangular part of A is filled with data.
! --- The machine independent random number generator ran1 is used.
! --- Author: R.J. van der Pas (ACCU, Utrecht, The Netherlands)
! ----------------------------------------------------------------------
! --- Parameters.

      Integer       :: n
      Real(l_)      :: a(n,n)
!
! --- Local variables.

      Integer       :: idum, i, j
!
! --- External functions.

      Real(l_)      :: ran1
! ----------------------------------------------------------------------
! --- Initialize the generator.

      idum = -1
!
      Do j = 1, n
         Do i = j, n
            a(i,j) = ran1( idum )
         End Do
      End Do
! ----------------------------------------------------------------------
      Return
      End
