      Subroutine sym7pre( n1, n2, n3, a, b, fac )
! ---------------------------------------------------------------------
! --- sym7pre computes the inverse of D as used in the preconditioners.
!     Also the elements of A and RHS b are adjusted.
! ---------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Implicit    None

      Integer  :: n1 ,n2 ,n3
      Real(l_) :: a(n1*n2*n3,0:3), b(n1*n2*n3), fac(n1*n2*n3)

      Integer  :: i, inm, in12, ntot, n12
! ---------------------------------------------------------------------
      n12  = n1*n2
      ntot = n12*n3
      fac(1) = 1.0_l_/a(1,0)
      Do i = 2, ntot
         inm    = i - 1
         fac(i) = a(i,0) - fac(inm)*a(inm,1)*a(inm,1)
      End Do
      Do i = n1 + 1, ntot
         inm    = i - n1
         fac(i) = fac(i) - fac(inm)*a(inm,2)*a(inm,2)
      End Do
      Do i = n12 + 1, ntot
         inm    = i - n12
         fac(i) = fac(i) - fac(inm)*a(inm,3)*a(inm,3)
      End Do
      fac = 1.0_l_/fac
! ---------------------------------------------------------------------
! --- D-inverse is now complete, scale A and b.

      a(1:ntot,0) = a(1:ntot,0)*fac
      fac         = Sqrt( fac )
      b           = b*fac
      Do i = 2, ntot
         inm      = i - 1
         a(inm,1) = fac(i)*fac(inm)*a(inm,1)
      End Do
      Do i = n1 + 1, ntot
         inm      = i - n1
         a(inm,2) = fac(i)*fac(inm)*a(inm,2)
      End Do
      Do i = n12 + 1, ntot
         inm     = i - n12
         a(inm,3) = fac(i)*fac(inm)*a(inm,3)
      End Do
      flops = flops + 25*ntot - 6*( n1 + n12 ) - 5
! ---------------------------------------------------------------------
! --- Keep fac for backscaling the solution x.
! ---------------------------------------------------------------------
      End Subroutine sym7pre

