      Subroutine sym7pol( n1, n2, n3, m, a, rmr, q, x, y, gamma )
! ---------------------------------------------------------------------
! --- Polynomial (Neumann) preconditioner.
! ---------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Implicit    None

      Integer  :: n1, n2, n3, m
      Real(l_) :: a(n1*n2*n3,0:3), rmr, q(n1*n2*n3), x(n1*n2*n3),
     &            y(n1*n2*n3)
      Real(l_) :: gamma(m+1)
      Real(l_) :: nrm2

      Real(l_) :: t(n1*n2*n3), w(n1*n2*n3)
      Integer  :: i, j, n12, ntot
! ---------------------------------------------------------------------
      n12  = n1*n2
      ntot = n12*n3
      t = q*x
      y = t
      y = gamma(m+1)*y
      Do i = 1, m
         Call sym7mxv( n1, n2, n3, a, y, w )
         w = q*w
         y = y - w
         y = y + gamma(m-i+1)*t
      End Do
! ---------------------------------------------------------------------
! --- Computation of (r,Mr) where M is the preconditioner.

      rmr = nrm2( ntot, y )
      flops = flops + ntot*( 2 + 4*m )
! ---------------------------------------------------------------------
      End Subroutine sym7pol
