      Subroutine sym7gen( ntot, a, b )
! ----------------------------------------------------------------------
! --- sym7gen generates the 4 upper diagonals of a 7-diagonal symmetric
!     matrix to be solved by a GC iterative solver. Also the RHS, b is
!     generated.
!     Real(l_) a(n1*n2*n3,0:3) : Matrix to be generated.
!     Real(l_) b(n1*n2*n3)     : Right hand side.
! ----------------------------------------------------------------------
      Use                    numerics
      Use                    ran_module
      Implicit               None

      Integer             :: ntot
      Real(l_)            :: a(ntot,0:3)
      Real(l_)            :: b(ntot)

      Integer             :: i
      Real(l_)            :: offdg
! ----------------------------------------------------------------------
      Call rinit
      Call ranfil( a(1,1), ntot*3 )
      Do i = 1, ntot
         offdg  = Sum( a(i,1:3) )
         a(i,0) = 2.0_l_*offdg
      End Do
      Do i = 1, ntot
         a(i,1:3) = -a(i,1:3)/a(i,0)
         a(i,0)   = 1.0_l_
         b(i)     = Sum( a(i,1:3) ) + Sum( a(i,0:3) )
      End Do
! ----------------------------------------------------------------------
      End Subroutine sym7gen
