      Subroutine lpolyn( n, nel, m, indx, rowp, matvals, u, v, gamma )
! ----------------------------------------------------------------------
! --- Left polynomial preconditioner of order 'm'.
!     
! ----------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Implicit    None

      Integer  :: n, nel, m
      Integer  :: indx(nel), rowp(n+1)
      Real(l_) :: matvals(nel)
      Real(l_) :: u(n), v(n)
      Real(l_) :: gamma(m+1)

      Real(l_) :: w(n)
      Integer  :: i
! ----------------------------------------------------------------------
      v = gamma(m+1)*u
      Do i = 1, m
         Call spmxv( n, nel, indx, rowp, matvals, v, w )
         v = v - w
         v = v + gamma(m-i+1)*u
      End Do
      flops = flops + n*( 1 + 3*m )
! ----------------------------------------------------------------------
      End Subroutine lpolyn
