      Subroutine spmxv( nrows, nelmts, indx, rowp, matvals, invec, 
     &                  outvec )
! ----------------------------------------------------------------------
! --- 'spmxv' does the actual matrix-vector multiply using the 
!     matrix in CRS format (indx, rowp, matvals) and producing
!     vector 'outvec'.
! ----------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Implicit    None

      Integer  :: nrest, nrows, nelmts
      Integer  :: rowp(nrows), indx(nelmts)
      Real(l_) :: matvals(nelmts), invec(*), outvec(nrows)

      Integer  :: i, j
! ----------------------------------------------------------------------
      outvec = 0.0_l_
      Do i = 1, nrows
         nrest = Mod( rowp(i+1) - rowp(i), 4 )
         Do j = rowp(i), rowp(i+1) - 1 - nrest, 4
            outvec(i) = outvec(i) + matvals(j)*invec(indx(j))
     &                            + matvals(j+1)*invec(indx(j+1))
     &                            + matvals(j+2)*invec(indx(j+2))
     &                            + matvals(j+3)*invec(indx(j+3))
         End Do
         Do j = rowp(i+1) - nrest, rowp(i+1) - 1
            outvec(i) = outvec(i) + matvals(j)*invec(indx(j))
         End Do
      End Do    
      flops = flops + 2*nelmts
! ----------------------------------------------------------------------
      End Subroutine spmxv
