      Subroutine rotf( arg, c, s )
! ----------------------------------------------------------------------
! --- Recovers rotation factors c & s from 'arg' for the Givens
!     transformation (used in rgmres).
! ----------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Implicit    None

      Real(l_) :: arg, c, s
! ----------------------------------------------------------------------
      If ( arg == 0.0_l_ ) Then
         c = 0.0_l_
         s = 1.0_l_
      Else If ( Abs( arg ) < 1.0_l_ ) Then
         s = 2.0_l_*arg
         c = Sqrt( 1.0_l_ - s*s )
         flops = flops + 12
      Else
         c = 2.0_l_/arg
         s = Sqrt( 1.0_l_ - c*c )
         flops = flops + 12
      End If
! ----------------------------------------------------------------------
      End Subroutine rotf
