      Subroutine givens( a, b, c, s )
! ----------------------------------------------------------------------
! --- Calculates rotation factors c & s from 'a' and 'b' for the Givens
!     transformation (used in rgmres).
! ----------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Implicit    None

      Real(l_) :: a, b, c, s

      Real(l_) :: fac
! ----------------------------------------------------------------------
      If ( b == 0.0_l_ ) Then
         c = 1.0_l_
         s = 0.0_l_
      Else If ( Abs( b ) < Abs( a ) ) Then
         fac = -a/b
         s = 1.0_l_/Sqrt( 1.0_l_ + fac*fac )
         c = fac*s
         flops = flops + 13
      Else
         fac = -b/a
         c = 1.0_l_/Sqrt( 1.0_l_ + fac*fac )
         s = fac*c
         flops = flops + 13
      End If
! ----------------------------------------------------------------------
      End Subroutine givens
