      Subroutine wrtab ( maxi, tab, nn, narr, ident, xint, yint )
! ----------------------------------------------------------------------
! --- Print data in table tab(i,j), i = 1,...,maxi, j = 1,...,nn.
! ----------------------------------------------------------------------
      Use                   numerics
      Implicit              None

      Integer            :: maxi, nn
                              ! --- Standard output unit is assumed 6.
      Integer, Parameter :: nfmax = 100, nmax = 50, inn = 4, lout = 6
      Integer            :: narr(nmax)
      Real(l_)           :: tab(nfmax,nmax)
      Character(8)       :: ident(nfmax)
      Real(l_)           :: xint(nfmax,2), yint(2)

      Integer            :: i, i1, i2, j, k, m, n12
      Real(l_)           :: dt, t12
      Character          :: form1*37, form2*41
! ----------------------------------------------------------------------
      i1 = 1
! ----------------------------------------------------------------------
! --- At most 10 pages

      Do k = 1, 10

! --- Print heading
! ----------------------------------------------------------------------
         Print 100
         Print 200
         Print 300
         If ( k > 1 ) Then
            Print 400 
            Print 200
         Else
            Print 200
         End If
! ----------------------------------------------------------------------
! --- Write title line for table 

         i2    = Min( nn, i1+inn )
         form1 =  '(16x,''Interval      n='',  i9,''     '')'
         Write( form1(25:26), '(i2)' ) i2 - i1 + 1
         If ( i2 >= nn ) Then
            form1(31:35) = ' n1/2'
         End If
         Write( lout, form1 ) ( narr(i) ,i = i1, i2 )
         Print 200
! ----------------------------------------------------------------------
! --- Write table 

         Do m = 1, maxi

! --- write m-th row of tab ..... 
! ----------------------------------------------------------------------
            form2 = '(1x,a8,''('',e10.3,'','',e10.3,'')'',  f9.3   )'
            Write( form2(32:33), '(i2)' ) i2 - i1 + 1
            If ( i2 < nn ) Then
! ----------------------------------------------------------------------
! --- ..... without n1/2 

               Write (lout,form2) ident(m), xint(m,1), xint(m,2),
     &                            ( tab(m,i), i = i1, i2 )
            Else
! ----------------------------------------------------------------------
! --- ..... With calculating n1/2 and printing it

               t12 = tab(m,nn)/2
               Do j = nn, 1, -1
                  If ( tab(m,j) < t12 ) Then
                     dt = tab(m,j+1) - tab(m,j)
                     If ( dt > 0.0 ) Then
                        n12 = narr(j) + ( narr(j+1) - narr(j) )*
     &                     ( (t12 - tab(m,j) )/dt )
                     Else
                        n12 = narr(j)
                     End If
                     Go To 800
                  End If
               End Do
               n12 = 0
 800           Continue
               form2(38:40) = ',i5'
               Write ( lout, form2 ) ident(m), xint(m,1), xint(m,2),
     &                               ( tab(m,i), i = i1,i2 ), n12
            End If
            If ( m == 3 ) Then
            Print 500, yint(1), yint(2)

         End If
         If ( m ==  3 .OR. m ==  6 .OR. m ==  9 .OR.
     &        m == 12 .OR. m == 16 .OR. m == 20 .OR.
     &        m == 25 .OR. m == 29 .OR. m == 33 ) Print 600
         End Do

         If ( i2 >= nn ) Return
         i1 = i2 + 1
      End Do
! ----------------------------------------------------------------------
  100 Format( /'------------------------------------------------------',
     &         '-----------------------' )
  200 Format('  ')
  300 Format( ' Performance rates in Mega-function-calls/sec.' )
  400 Format( ' (Continued)' )
  500 Format( 9x, '(', e10.3, ',', e10.3, ')' )
  600 Format( 1x )
! ----------------------------------------------------------------------
      End Subroutine wrtab
