      Subroutine summ ( ch, j, r6, r7, a, b, c, d, x1, y1 )
c ----------------------------------------------------------------------
c --- summ prints a summary.

      Implicit None
      Double Precision r6, r7, a, b, c, d, x1, y1
      Integer          j, izr, iout, minexp, maxexp, n, i, idum
      Character        ch*8
      Character*65     hard, soft, place, remark
      Common /blcomp/  hard, soft, place, remark
      Common /blmaco/  ibeta, idum, it, irnd, minexp, maxexp, xmin, xmax
      Common /blprnt/  prall, iout, n
      Logical          prall
      Integer          ja(50), ibeta, it, irnd
      Double Precision ra(50,8), xmin, xmax, w6, w7, decdig
      Character*8      cha(50)
      Save             ja, ra, cha, izr
c ----------------------------------------------------------------------
      If ( j .EQ. 0 ) Then
         izr = 0
         Return
      End If
      If ( j .GT. 0 ) Then
         izr       = izr + 1
         cha(izr)  = ch
         ja(izr)   = j
         ra(izr,1) = r6
         ra(izr,2) = r7
         ra(izr,3) = x1
         ra(izr,4) = a
         ra(izr,5) = b
         If (ch .EQ. 'X**Y') Then
            ra(izr,6) = c
            ra(izr,7) = d
            ra(izr,8) = y1
         End If
         Return
      End If
      If ( j .LT. 0 ) Then
         decdig = Dble ( IT )*Log10 ( Dble ( ibeta ) )
         If ( j .EQ. -1 ) Print 9
    9    Format( //,' Accuracy elementary functions (Scalar)', 23X,
     &          'Summary (Decimal)'/1X, 38('-'), 23X, 17('-')/ )
         If ( j .EQ. -2 ) Print 10
   10    Format( //,' Accuracy elementary functions (Scalar)',20X,
     &          'Summary (Base Ibeta)'/1X, 38('-'), 20X, 20('-')/ )
         Print 13, ibeta, minexp, xmin, it, maxexp, xmax, irnd,
     &                  n, decdig
   13    Format(' ibeta =',I3,'   minexp =',I6,'   xmin       =',G16.7/
     &          ' it    =',I3,'   maxexp =',I6,'   xmax       =',G16.7/
     &          ' irnd  =',I3,'           ',6X,'               '      /
     &          ' n  ='   ,I6,'           ',6X,'   Dec.Digits =',F7.3/ )
         If ( j .EQ. -1 ) Print 14
   14    Format ( 45X, 'Loss of decimal digits'/
     &          ' Function test ','            Interval           ',
     &          4X, 'RMS', 5X, 'Max','       Max at x =' )
         If ( j .EQ. -2 ) print 19
   19    Format ( 45X, 'Loss of base-IBETA digits'/
     &          ' Function test ','            Interval           ',
     &          4X, 'RMS', 5X, 'Max','       Max at x =' )
         Do i = 1, izr
            If ( ja(i) .EQ. 1 ) Print 15
   15       Format (' ')
            w6 = 0.0D0
            w7 = 0.0D0
            If ( ra(i,1) .NE. 0.0D0 ) 
     &         w6 = Max ( Log10 ( Abs(  ra(i,1) ) ) + decdig, w6 )
            If ( ra(i,2) .NE. 0.0D0 )
     &         w7 = Max ( Log10 ( Abs ( ra(i,2) ) ) + decdig, w7 )
            If ( j .EQ. -2 ) Then
               w6 = w6/Log10 ( Dble ( ibeta ) )
               w7 = w7/Log10 ( Dble ( ibeta ) )
            End If
            Print 16, cha(i), ja(i), ra(i,4), ra(i,5), w7, w6, ra(i,3)
   16       Format ( 1X, A8, I3, '  (', E14.7, ',', E14.7, ')', 2F8.2,
     &               2X, E14.7 )
            If (cha(i) .EQ. 'X**Y' ) Then
               Print 17, ra(i,6), ra(i,7), ra(i,8)
   17          Format ( 14X, '(', E14.7, ',', E14.7, ')', 16X, 'y =',
     &                  E14.7 )
            End If
         End Do
c ----------------------------------------------------------------------
         Return
      End If
      End
