      Subroutine stan
      Implicit None
      External dran1, summ
      Common /blmaco/ ibeta, idum, it, irnd, minexp, maxexp, xmin, xmax
      Common /blprnt/ prall, iout, n
      Logical prall
c
c --- Program to test tan/cot.
c
c --- Data required:
c
c        None
c
c --- Subprograms required from this package:
c
c                 IBETA         - The radix of the floating-point
c                                 system.
c                 IT            - The number of base-ibeta digits in
c                                 the significand of a floating-point
c                                 number.
c                 IRND          - 0 if floating-point addition chops,
c                                 1 if floating-point addition rounds.
c                 dran1( idum ) - A function subprogram returning
c                                 random _REAL_ numbers uniformly             
c                                 distributed over (0,1)
c
c --- Standard FORTRAN subprograms required:
c
c         Abs,  Log,  Max, Cot,  Dble, Tan, Sqrt
c
c
c --- Latest revision - December 6, 1979
c
c --- Author - W. J. Cody
c              Argonne National Laboratory
c
c ----------------------------------------------------------------------
      Integer          i, ibeta, iexp, iout, irnd, it, i1, j, k, k1,
     &                 k2, k3, l, m, machep, Maxexp, minexp, n, negep,
     &                 ngrd, idum
      Double Precision a, ait, albeta, b, beta, betap, c1, c2, del,
     &                 half, cot,  pi, dran1, r6, r7, w, x, xl, xMax,
     &                 xmin, xn, x1, y, z, zero, zz, dummy
      Character*8      char(4)
c
      char(1) = 'Tan(x)'
      char(2) = 'Tan(x)'
      char(3) = 'Tan(x)'
      char(4) = 'Cot(x)'
c
      beta    = Dble ( ibeta )
      albeta  = Log ( beta )
      zero    = 0.0D0
      half    = 0.5D0
      ait     = Dble( it )
      pi      = 3.14159265D0
      a       = zero
      b       = pi*0.25D0
      xn      =  Dble ( n )
      i1      = 0
c-----------------------------------------------------------------
c     Random argument accuracy tests.
c-----------------------------------------------------------------
      Do j = 1, 4
         k1 = 0
         k3 = 0
         x1 = zero
         r6 = zero
         r7 = zero
         del = ( b - a ) / xn
         xl = a
c
         Do i = 1, n
            x = del* dran1 ( idum ) + xl
            y = x * half
            x = y + y
            If ( j .EQ. 4 ) Go To 80
            z  = Tan ( x )
            zz = Tan ( y )
            w = 1.0D0
            If ( z .EQ. zero ) Go To 110
            w = ( ( half - zz ) + half )*( ( half + zz ) + half )
            w = ( z - ( zz + zz )/w )/z
            Go To 110
   80       z  =  Cot(x)
            zz =  Cot(y)
            w  = 1.0D0
            If ( z .EQ. zero ) Go To 110
            w = ( ( half - zz ) + half )*( ( half + zz ) + half )
            w = ( z + w/( zz + zz ) )/z
  110       If ( w .GT. zero) k1 = k1 + 1
            If ( w .LT. zero) k3 = k3 + 1
            w = Abs ( w )
            If ( w .LE. r6 ) Go To 120
            r6 = w
            x1 = x
  120       r7 = r7 + w*w
            xl = xl + del
         End Do
c
         k2 = n - k3 - k1
         r7 = Sqrt ( r7/xn )
         If ( j .NE. 4 .AND. prall ) Print 1000
         If ( j .EQ. 4 .AND. prall ) Print 1005
         If ( prall ) Print 1010, n, a, b
         If ( j .NE. 4 .AND. prall ) Print 1011, k1, k2, k3
         If ( j .EQ. 4 .AND. prall ) Print 1012, k1, k2, k3
         If ( prall ) Print 1020, it, ibeta
         w = -999.0D0
         If ( r6 .ne. zero ) w =  Log ( Abs ( r6 ) )/albeta
         If ( prall ) Print 1021, r6,ibeta,w,x1
         w =  Max ( ait + w, zero )
         If ( prall ) Print 1022, ibeta, w
         w = -999.0D0
         If ( r7 .ne. zero ) w =  Log (Abs ( r7) )/albeta
         If ( prall ) Print 1023, r7, ibeta, w
         w =  Max ( ait + w, zero )
         If ( prall ) Print 1022, ibeta, w
         Call summ ( char(j), j, r6, r7, a, b, dummy, dummy, x1,
     &               dummy )
         If ( j .NE. 1 ) Go To 250
         a = pi*0.875D0
         b = pi*1.125D0
         Go To 300
  250    a = pi*6.0D0
         b = a + pi*0.25D0
  300    Continue
      End Do
      If ( prall ) Print 1100
c ----------------------------------------------------------------------
      Return
 1000 Format ( '1Test of Tan(x) vs 2*Tan(x/2)/(1-Tan(x/2)**2) '// )
 1005 Format ( '1Test of Cot(x) vs (Cot(x/2)**2-1)/(2*Cot(x/2)) '// )
 1010 Format ( I7,' Random arguments were tested from the interval '/
     & 6X,'(',E15.4,',',E15.4,')'// )
 1011 Format ( ' Tan(x) was larger',I6,' times,' /
     &     11X,' agreed',I6,' times, and '/
     &   7X,'was smaller',I6,' times.'// )
 1012 Format ( ' Cot(x) was larger',I6,' times,' /
     &     11X,' agreed',I6,' times, and '/
     &   7X,'was smaller',I6,' times.'//)
 1020 Format ( ' There are',I4,' base',I4,
     &    ' significant digits in a floating-point number  '//)
 1021 Format ( ' The maximum relative error of',E15.4,' = ',I4,' **',
     &  F7.2/4X,'occurred for x =',E17.6)
 1022 Format ( ' The estimated loss of base',I4,
     &  ' significant digits is',F7.2//)
 1023 Format ( ' The root mean square relative error was',E15.4,
     &    ' = ',I4,' **',F7.2)
 1100 Format ( ' This concludes the tests ')
c ----------------------------------------------------------------------
      End
