      Subroutine spower
      Implicit None
      External dran1, summ
      Common /blmaco/ ibeta, idum, it, irnd, minexp, maxexp, xmin, xmax
      Common /blprnt/ prall, iout, n
      Logical prall
c
c --- Program to test power function (**).
c
c --- Data required:
c
c        None
c
c --- Subprograms required from this package:
c
c                 IBETA         - The radix of the floating-point
c                                 system.
c                 IT            - The number of base-ibeta digits in
c                                 the significand of a floating-point
c                                 number.
c                 IRND          - 0 if floating-point addition chops,
c                                 1 if floating-point addition rounds.
c                 dran1( idum ) - A function subprogram returning
c                                 random _REAL_ numbers uniformly             
c                                 distributed over (0,1)
c
c --- Standard FORTRAN subprograms required:
c
c         Abs,  Log,  Max , Exp,  Dble, Sqrt
c
c
c --- Latest revision - December 6, 1979
c
c --- Author - W. J. Cody
c              Argonne National Laboratory
c
c ----------------------------------------------------------------------
      Integer          i, ibeta, iexp, iout, irnd, it, i1, j, k, k1,
     &                 k2, k3, l, m, machep, maxexp, minexp, n, negep,
     &                 ngrd, idum
      Double Precision a, ait, albeta, alxmax, b, beta, c, del, dely,
     &                 ONE, onep5, dran1, r6, r7, scale, two, w, x, xl,
     &                 xmax, xmin, xn, xsq, x1, y, y1, y2 ,z, zero, zz
      Character*8      char(4)
      Double Precision wsave
c
      char(1) = 'x**1.0'
      char(2) = 'xsq**1.5'
      char(3) = 'xsq**1.5'
      char(4) = 'x**y'
c
      beta    =  Dble(ibeta)
      albeta  =  Log (  beta)
      ait     =  Dble(it)
      alxmax  =  Log (  xmax)
      zero    = 0.0D0
      one     =  Dble(1)
      two     = one + one
      onep5   = (two + one) / two
      scale   = one
      j       = (it+1) / 2
c
      Do i = 1, j
         scale = scale * beta
      End Do
c
      a    = one / beta
      b    = one
      c    = - max (alxmax,- Log (  xmin))/ Log (  100D0)
      dely = -c - c
      xn   =  Dble(n)
      i1   = 0
      y1   = zero
c-----------------------------------------------------------------
c     Random argument accuracy tests.
c-----------------------------------------------------------------
      Do j = 1, 4
         k1  = 0
         k3  = 0
         x1  = zero
         r6  = zero
         r7  = zero
         del = ( b - a ) / xn
         xl  = a
c
         Do i = 1, n
            x = del *dran1 ( idum ) + xl
            If ( j .ne. 1 ) Go To 50
            zz = x ** one
            z = x
            Go To 110
   50       w = scale * x
            x = ( x + w ) - w
            xsq = x * x
            If ( j .eq. 4 ) Go To 70
            zz = xsq ** onep5
            z = x * xsq
            Go To 110
   70       y = dely * dran1 ( idum ) + c
            y2 = ( y/two + y ) - y
            y = y2 + y2
            z = x ** y
            zz = xsq ** y2
  110       w = one
            If ( z .ne. zero ) w = ( z - zz ) / z
            If ( w .gt. zero ) k1 = k1 + 1
            If ( w .lt. zero ) k3 = k3 + 1
            w = Abs ( w )
            If ( w .le. r6 ) Go To 120
            r6 = w
            x1 = x
            If ( j .eq. 4 ) y1 = y
  120       r7 = r7 + w * w
            xl = xl + del
         End Do
c
         k2 = n - k3 - k1
         r7 = Sqrt ( r7/xn )
         If ( j .gt. 1 ) Go To 210
         If ( prall ) Print 1000
         If ( prall ) Print 1010, n, a, b
         If ( prall ) Print 1011, k1, k2, k3
         Go To 220
  210    If ( j .eq. 4 ) Go To 215
         If ( prall ) Print 1001 
         If ( prall ) Print 1010, n, a, b
         If ( prall ) Print 1012, k1, k2, k3
         Go To 220
  215    If ( prall ) Print 1002 
         w = c + dely
         wsave = w
         If ( prall ) Print 1014, n, a, b, c, w
         If ( prall ) Print 1013, k1, k2, k3
  220    If ( prall ) Print 1020, it, ibeta
         w = -999.0D0
         If ( r6 .NE. zero) w =  Log ( Abs ( r6) ) /albeta
         If ( j .ne. 4 .AND. prall ) Print 1021, r6, ibeta, w ,x1
         If ( j .eq. 4 .AND. prall ) Print 1024, r6, ibeta, w, x1, y1
         w =  Max ( ait + w, zero )
         If ( prall ) Print 1022, ibeta, w
         w = -999.0D0
         If ( r7 .ne. zero) w =  Log ( Abs ( r7 ) )/albeta
         If ( prall ) Print 1023, r7, ibeta, w
         w =  Max ( ait + w, zero )
         If ( prall ) Print 1022, ibeta ,w
         call summ ( char(j), j, r6, r7, a, b, c, wsave, x1, y1 )
         If ( j .EQ. 1 ) Go To 300
         b = 10.0D0
         a = 0.01D0
         If ( j .EQ. 3 ) Go To 300
         a = one
         b = Exp ( alxmax/3.0D0 )
  300 Continue
      End Do
      If ( prall ) Print 1100
c ----------------------------------------------------------------------
      Return
 1000 Format ( '1Test of x**1.0 vs x  '// )
 1001 Format ( '1Test of xsq**1.5 vs xsq*x  '// )
 1002 Format ( '1Test of x**y vs xsq**(y/2)  '// )
 1010 Format ( I7,' Random arguments were tested from the interval '/
     & 6X,'(',E15.4,',',E15.4,')'// )
 1011 Format ( ' X**1.0 was larger',I6,' times,' /
     &     11X,' agreed',I6,' times, and '/
     &   7X,'was smaller',I6,' times.'// )
 1012 Format ( ' x**1.5 was larger',I6,' times,' /
     &     11X,' agreed',I6,' times, and '/
     &   7X,'was smaller',I6,' times.'// )
 1013 Format ( '  x**y  was larger',I6,' times,' /
     &     11X,' agreed',I6,' times, and '/
     &   7X,'was smaller',I6,' times.'// )
 1014 Format ( I7,' Random arguments were tested from the region '/
     & 6X,'X in (',E15.4,',',E15.4,'), Y in (',E15.4,',',E15.4,')'// )
 1020 Format ( ' There are',I4,' base',I4,
     &    ' significant digits in a floating-point number  '// )
 1021 Format ( ' The maximum relative error of',E15.4,' = ',I4,' **',
     &  F7.2/4X,'occurred for X =',E17.6 )
 1022 Format ( ' The estimated loss of base',I4,
     &  ' significant digits is',F7.2// )
 1023 Format ( ' The root mean square relative error was',E15.4,
     &    ' = ',I4,' **',F7.2 )
 1024 Format ( ' The maximum relative error of',E15.4,' = ',I4,' **',
     &  F7.2/4X,'occurred for x =',E17.6,' y =',E17.6)
 1100 Format ( ' This concludes the tests ')
c ----------------------------------------------------------------------
      End
