      Subroutine slog
      Implicit None
      External dran1, summ
      Common /blmaco/ ibeta, idum, it, irnd, minexp, maxexp, xmin, xmax
      Common /blprnt/ prall, iout, n
      Logical prall
c
c --- Program to test  Log.
c
c
c --- Data required:
c
c        None
c
c --- Subprograms required from this package:
c
c                 IBETA         - The radix of the floating-point
c                                 system.
c                 IT            - The number of base-ibeta digits in
c                                 the significand of a floating-point
c                                 number.
c                 IRND          - 0 if floating-point addition chops,
c                                 1 if floating-point addition rounds.
c                 dran1( idum ) - A function subprogram returning
c                                 random _REAL_ numbers uniformly             
c                                 distributed over (0,1)
c
c --- Standard FORTRAN subprograms required:
c
c         Abs,  Log,  Log10,  Max ,  Dble, Int, Sqrt
c
c
c --- Latest revision - December 6, 1979
c
c --- Author - W. J. Cody
c              Argonne National Laboratory
c
c ----------------------------------------------------------------------
      Integer          i, ibeta, iexp, iout, irnd, it, i1, j, k, k1,
     &                 k2, k3, l, m, machep, maxexp, minexp, n, negep,
     &                 ngrd, idum
      Double Precision a, ait, albeta, b, beta, c, del, eight, half,
     1                 one, dran1, r6, r7, tenth, w, x, xl, xmax, xmin,
     2                 xn, x1, y, z, zero, zz, dummy
      Character*8 char(4)
c
      char(1) = 'Log(x)'
      char(2) = 'Log(x)'
      char(3) = 'Log10(x)'
      char(4) = 'Log(x)'
c
      beta    =  Dble ( ibeta )
      albeta  =  LOG ( beta )
      ait     =  Dble( it )
      j       = it / 3
      zero    = 0.0D0
      half    = 0.5D0
      eight   = 8.0D0
      tenth   = 0.1D0
      one     = 1.0D0
      c       = one
c
      Do i = 1, j
         c = c / beta
      End Do
c
      b  = one + c
      a  = one - c
      xn =  Dble ( n )
      i1 = 0
c-----------------------------------------------------------------
c     Random argument accuracy tests.
c-----------------------------------------------------------------
      Do j = 1, 4
         k1 = 0
         k3 = 0
         x1 = zero
         r6 = zero
         r7 = zero
         del = (b - a) / xn
         xl = a
c
         Do i = 1, n
            x  = del * dran1 (idum ) + xl
            If ( j .NE. 1) Go To  100
            y  = ( x - half ) - half
            zz =  Log ( x )
            z  = one / 3.0D0
            z  = y * ( z - y / 4.0D0 )
            z  = ( z - half ) * y * y + y
            Go To  150
  100       If ( L .NE. 2) Go To  110
            x  = (x + eight) - eight
            y  = x + x / 16.0D0
            z  =  Log ( x )
            zz =  Log ( Y ) 
     &            - 7.77468164348425806061320404202632862D-5
            zz = zz - 31.0D0/512.0D0
            Go To  150
  110       If ( j .NE. 3 ) Go To  120
            x  = ( x + eight ) - eight
            y  = x + x * tenth
            z  =  Log10 ( x )
            zz =  Log10 ( y )
     &            - 3.77060158225040750199971243024241707D-4
            zz = zz - 21.0D0/512.0D0
            Go To  150
  120       z  = Log ( x*x )
            zz = Log ( x )
            zz = zz + zz
  150       w = one
            If ( z .NE. zero ) w = ( z - zz ) / z
            z = Sign ( w, z )
            If ( z .GT. zero ) k1 = k1 + 1
            If ( z .LT. zero ) k3 = k3 + 1
            w = Abs ( w )
            If ( w .LE. r6 ) Go To  160
            r6 = w
            x1 = x
  160       r7 = r7 + w*w
            xl = xl + del
         End Do
c
         k2 = n - k3 - k1
         r7 = Sqrt ( r7/xn )
         If ( j .EQ. 1 .AND. prall ) Print  1000 
         If ( j .EQ. 2 .AND. prall ) Print  1001 
         If ( j .EQ. 3 .AND. prall ) Print  1005 
         If ( j .EQ. 4 .AND. prall ) Print  1002 
         If ( j .EQ. 1 .AND. prall ) Print  1009, n, c
         If ( j .NE. 1 .AND. prall ) Print  1010, n, a, b
         If ( j .NE. 3 .AND. prall ) Print  1011, k1, k2, k3
         If ( j .EQ. 3 .AND. prall ) Print  1012, k1, k2, k3
         If ( prall ) Print  1020, it, ibeta
         w = -999.0D0
         If ( r6 .NE. zero ) w =  Log ( Abs ( r6 ) )/albeta
         If ( prall ) Print  1021, r6, ibeta, w, x1
         w =  Max ( ait + w ,zero )
         If ( prall ) Print  1022, ibeta, w
         w = -999.0D0
         If ( r7 .NE. zero ) w =  Log ( Abs ( r7 ) )/albeta
         If ( prall ) Print  1023, r7, ibeta, w
         w =  Max ( ait + w ,zero )
         If ( prall ) Print  1022, ibeta,w
         Call summ ( char(j), j, r6, r7, a, b, dummy, dummy, x1,
     &               dummy )
         If ( j .GT. 1) Go To  230
         a = Sqrt ( half )
         b= 15.0D0 / 16.0D0
         Go To  300
  230    If ( J .GT. 2) Go To  240
         a = Sqrt ( tenth )
         b = 0.9D0
         Go To  300
  240    a = 16.0D0
         b = 240.0D0
  300    Continue
      End Do
      If ( prall ) Print  1100
c ----------------------------------------------------------------------
      Return
 1000 Format ( '1Test of  Log(x) vs T.S. expansion of  Log(1+y)  '// )
 1001 Format ( '1Test of  Log(x) vs  Log(17x/16)- LOG(17/16)   '// )
 1002 Format ( '1Test of  Log(x *X) vs 2 * Log(x )  '// )
 1005 Format ( '1Test of  LOG10(X) vs  LOG10(11X/10)- LOG10(11/10) '// )
 1009 Format ( I7,' Random arguments were tested from the interval '/
     1 6X,'(1-eps,1+eps), where eps =', E15.4// )
 1010 Format ( I7,' Random arguments were tested from the interval '/
     1 6X,'(',E15.4,',',E15.4,')'// )
 1011 Format ( '  Log(x) was larger',I6,' times,' /
     1     12X,' agreed',I6,' times, and '/
     2     8X,'was smaller',I6,' times.'// )
 1012 Format ( '  Log10(x) was larger',I6,' times,' /
     1     14X,' agreed',I6,' times, and '/
     2     10X,'was smaller',I6,' times.'// )
 1020 Format ( ' There are',I4,' base',I4,
     1    ' significant digits in a floating-point number  '// )
 1021 Format ( ' The maximum relative error of',E15.4,' = ',I4,' **',
     1  F7.2/4X,'occurred for X =',E17.6 )
 1022 Format ( ' The estimated loss of base',I4,
     1  ' significant digits is',F7.2// )
 1023 Format ( ' The root mean square relative error was',E15.4,
     1    ' = ',I4,' **',F7.2 )
 1100 Format ( ' This concludes the tests ' )
c ----------------------------------------------------------------------
      End
