      Subroutine sasin
      Implicit None
      External dran1, summ
      Common /blmaco/ ibeta, idum, it, irnd, minexp, maxexp, xmin, xmax
      Common /blprnt/ prall, iout, n
      Logical prall
c
c --- Program to test Asin/Acos
c
c --- Data required:
c
c        None
c
c --- Subprograms required from this package:
c
c                 IBETA         - The radix of the floating-point
c                                 system.
c                 IT            - The number of base-ibeta digits in
c                                 the significand of a floating-point
c                                 number.
c                 IRND          - 0 if floating-point addition chops,
c                                 1 if floating-point addition rounds.
c                 dran1( idum ) - A function subprogram returning
c                                 random _REAL_ numbers uniformly             
c                                 distributed over (0,1)
c
c --- Standard FORTRAN subprograms required:
c
c         Abs, Acos,  Log,  Log10,  Max , Asin,  Dble, Int, Sqrt
c
c
c --- Latest revision - December 6, 1979
c
c --- Author - W. J. Cody
c              Argonne National Laboratory
c
c ----------------------------------------------------------------------
      Integer          i, ibeta, iexp, iout, irnd, it, i1, j, k, k1,
     &                 k2, k3, l, m, machep, maxexp, minexp, n, negep,
     &                 ngrd, idum
      Double Precision a, ait, albeta, b, beta, betap, c1, c2, del,
     &                 half, dran1, r6, r7, s, sum, w, x, xl, xm,
     &                 xmax, xmin, xn, x1, y, ysq, z, zero, zz, dummy
      Character*8      char(5)
c
      char(1) = 'Asin(x)'
      char(2) = 'Acos(x)'
      char(3) = 'Asin(x)'
      char(4) = 'Acos(x)'
      char(5) = 'Acos(x)'
c
      beta   =  Dble ( ibeta )
      albeta =  Log ( beta )
      zero   = 0.0D0
      half   = 0.5D0
      ait    =  Dble ( it )
      k      = Int ( Log10 ( beta**it ) ) + 1
      If (ibeta .NE. 10) Go To 20
      c1 = 1.57D0
      c2 = 7.96326794896619231321691639751442099D-4
      Go To 30
   20 c1 = 201.0D0/128.0D0
      c2 = 4.83826794896619231321691639751442099D-4
   30 a = -0.125D0
      b = -a
      xn =  Dble( n )
      i1 = 0
      l = -1
c-----------------------------------------------------------------
c     Random argument accuracy tests.
c-----------------------------------------------------------------
      Do j = 1, 5
         k1 = 0
         k3 = 0
         l = -l
         x1 = zero
         r6 = zero
         r7 = zero
         del = (b - a) / xn
         xl = a
c
         Do i = 1, n
            x = del*dran1 ( idum ) + xl
            If ( j .LE. 2 ) Go To 40
            ysq = half - half*Abs ( x )
            x = ( half - ( ysq + ysq ) ) + half
            IF (j .EQ. 5 ) x = -x
            y = Sqrt ( ysq )
            y = y + y
            Go To 50
   40       y = x
            ysq = y*y
   50       sum = zero
            xm =  Dble ( k+k+1 )
            If (l .GT. 0 ) z = Asin ( x )
            if (l .LT. 0 ) z = Acos ( x )
c
            Do m = 1, k
               sum = ysq*( sum + 1.0D0/xm )
               xm  = xm - 2.0D0
               sum = sum*( xm/( xm + 1.0D0 ) )
            End Do
c
            sum = sum*y
            If ( ( j .NE. 1 ) .AND. (j .NE. 4 ) ) Go To 70
            zz = y + sum
            sum = (y - zz) + sum
            If ( irnd .NE. 1 ) zz = zz + ( sum + sum )
            Go To 110
   70       s = c1 + c2
            sum = ( ( c1 - s ) + c2 ) - sum
            zz = s + sum
            sum = ( ( s - zz ) + sum ) - y
            s = zz
            zz = s + sum
            sum = ( s - zz ) + sum
            If ( irnd .NE. 1 ) zz = zz + ( sum + sum )
  110       w = 1.0D0
            If ( z .NE. zero ) w = ( z-zz )/z
            If ( w .GT. zero ) k1 = k1 + 1
            If ( W .LT. zero ) k3 = k3 + 1
            w = Abs ( w )
            If ( w .LE. r6 ) Go To 120
            r6 = w
            x1 = x
  120       r7 = r7 + w*w
            xl = xl + del
         End Do
c
         k2 = n - k3 - k1
         r7 = Sqrt ( r7/xn )
         If ( l .LT. 0 ) Go To 210
         If (prall) Print 1000 
         If ( prall ) Print 1010, n, a, b
         If ( prall ) Print 1011, k1, k2, k3
         Go To 220
  210    If ( prall ) Print 1005 
         If ( prall ) Print 1010, n, a, b
         If ( prall ) Print 1012, k1, k2, k3
  220    If ( prall ) Print 1020, it, ibeta
         w = -999.0D0
         If ( r6 .NE. zero ) w =  Log ( Abs ( r6 ) )/albeta
         If ( prall ) Print 1021, r6, ibeta, w, x1
         w =  Max ( ait + w, zero )
         If ( prall ) Print 1022, ibeta, w
         w = -999.0D0
         If ( r7 .NE. zero ) w =  Log ( Abs ( r7 ) )/albeta
         If ( prall ) Print 1023, r7, ibeta, w
         w =  Max ( ait + w, zero )
         If ( prall ) Print 1022, ibeta, w
         Call summ ( char(j), j, r6, r7, a, b, dummy, dummy, x1,
     &               dummy )
         If ( j .NE. 2 ) Go To 250
         a = 0.75D0
         b = 1.0D0
  250    If ( j .NE. 4 ) Go To 300
         b = -a
         a = -1.0D0
         c1 = c1 + c1
         c2 = c2 + c2
         l = -l
 300    Continue
      End Do
      If ( prall ) Print 1100
      Return
c ----------------------------------------------------------------------
 1000 Format ( '1Test of Asin(x) vs Taylor series '//)
 1005 Format ( '1Test of Acos(x) vs Taylor series '//)
 1010 Format ( I7,' Random arguments were tested from the interval '/
     1 6X,'(',E15.4,',',E15.4,')'//)
 1011 Format ( ' Asin(x) was larger',I6,' times,' /
     1     12X,' agreed',I6,' times, and '/
     2   8X,'was smaller',I6,' times.'//)
 1012 Format ( ' Acos(x) was larger',I6,' times,' /
     1     12X,' agreed',I6,' times, and '/
     2   8X,'was smaller',I6,' times.'//)
 1020 Format ( ' There are',I4,' base',I4,
     1    ' significant digits in a floating-point number  '//)
 1021 Format ( ' The maximum relative error of',E15.4,' = ',I4,' **',
     1  F7.2/4X,'occurred for X =',E17.6)
 1022 Format ( ' The estimated loss of base',I4,
     1  ' significant digits is',F7.2//)
 1023 Format ( ' The root mean square relative error was',E15.4,
     1    ' = ',I4,' **',F7.2)
 1100 Format ( ' This concludes the tests ')
c ----------------------------------------------------------------------
      End
