      Program mod1e
c
c **********************************************************************
c *** This program is part of the EuroBen Benchmark                  ***
c *** Copyright: EuroBen Group p/o                                   ***
c ***            Utrecht University, Computational Physics Dept.     ***
c ***            P.O. Box 80.000                                     ***
c ***            3508 TA Utrecht                                     ***
c ***            The Netherlands                                     ***
c ***                                                                ***
c *** Author of this program: Armin Friedli, ETH Zurich              ***
c *** Date                    Sept. 1989                             ***
c **********************************************************************
c
c  Version 2.0: Now a generic version (July 31, 1991, RvdP)
c
c
c   A C E F:   ACCURACY OF ELEMENTARY FUNCTIONS (SCALAR)
c   ----------------------------------------------------
c   (generic precision version: ACEFS)
c
c      This program tests the accuracy of the elementary function
c   subroutines  (as provided in FORTRAN) running in the scalar
c   unit of a computer. This program is based on the ELEFUNT package
c   as described in the book by
c        William J. Cody and William Waite:
c        Software Manual for the Elementary Functions,
c        Prentice-Hall, 1980.
c   Only the 'random argument accuracy tests' are carried out here.
c   These accuracy tests are performed by measuring mathematical
c   identities for arguments randomly distributed in selected
c   intervals. The 'special tests' and the 'tests for error returns'
c   from the original ELEFUNT software are not exercised here. There
c   is another version of the program (ACEFV) which is designed to
c   run the tests on the vector units of a computer and/or in parallel
c   on different processors.
c
c       ***********************************************************
c       * This program requires the definition of several machine *
c       * dependent constants, see PARAMETER statements below.    *
c       ***********************************************************
c
c      The results produced by this program must be interpreted
c   carefully because certain assumptions are made about the compiler
c   optimization, the architecture and the floating point arithmetic.
c   The tests performed were implemented very carefully in order not
c   to introduce rounding errors in addition to the errors produced by
c   the functions to be tested. It is important therefore that
c   statements like Y = (X+Y)-X are not 'optimized' by the compiler.
c   The intermediate result should be computed and stored. Also, it is
c   assumed that the arithmetic registers don't carry more significant
c   digits than do the memory registers. For more details, and what
c   kind of accuracies can be expected, see the reference mentioned
c   above.
c      The following FORTRAN intrinsic functions are tested: power (**),
c   SQRT, EXP, LOG/LOG10, SIN/COS, TAN/COT, ASIN/ACOS, ATAN, SINH/COSH,
c   TANH. If your computer system doesn't provide a cotangent function,
c   or if it isn't named COT, there is a template for a
c      Double Precision FUNCTION COT(X)
c   in which one can call the cotangent function by the appropriate
c   name or define it by a call to the tangent function.
c      The program produces a table summarizing the results.
c   The table gives for each test of a function the interval the
c   arguments were taken from, the root mean square (RMS) and the
c   maximum (MAX) of the loss of significant digits (in decimal as well
c   as in radix-base representation), and the argument at which the
c   maximum error occured. The printing of more detailed results
c   (i.e. statistics for each test of each function) can be invoked by
c   setting a variable in a PARAMETER statement below.
c      Other parameters that can be set are the number of random
c   arguments to be chosen in each interval, the seed for starting the
c   random number generator dran1, and the unit number for printing the
c   results. If one wishes to exclude certain functions (like TAN/COT)
c   from being tested, comment out the call to the corresponding
c   test subroutine (like CALL STAN).
c
c-----------------------------------------------------------------------
      Use      numerics
      Implicit None
      Common /blmaco/  ibetax, idumx, itx, irndx, minexx, maxexx, xmin,
     &                 xmax
      Common /blcomp/  hardx, softx, placex, remarx
      Common /blprnt/  prallx, ioutx, nx
      Logical          prall, prallx
      Real(l_)         xmin, xmax, decdig, dummy
      Integer          ibeta, it, irnd, minexp, maxexp, ibetax, idumx,
     &                 itx, irndx, n, nx
      Integer          iy, iyx, iout, ioutx, minexx, maxexx
      Character*65     hardx, softx, placex, remarx, hard, soft, place,
     &                 remark

c-- Convex: Bugs fixed

      Character*8      dumarg
      Data             dumarg, iy /'DumArg', 0/

      External         summ, spower, ssqrt, sexp, slog, ssin, stan,
     &                 sasin, satan, ssinh, stanh
c-----------------------------------------------------------------------
c
c   Define machine dependent constants:
c   IBETA = The radix of the floating point system.
c   IT    = The number of base-IBETA digits in the significant
c           of a floating point number.
c   IRND  = 0  if floating point addition chops,
c         = 1  if floating point addition rounds.
c   MINEXP= The largest in magnitude negative integer such that
c           XMIN = Dble(IBETA)**MINEXP is a positive floating point
c           number.
c   MAXEXP= The largest positive integer such that
c           XMAX = Dble(IBETA)**MAXEXP is a non-overflowing floating
c           point number. (This definition of MAXEXP/XMAX differs
c           slightly from the original ELEFUNT definition, but this
c           is not critical for our purposes.)

c-----------------------------------------------------------------------
c   Define further parameters:
c   PRALL = .TRUE.  print detailed results (30+ formatted pages) and
c                   summary,
c         = .FALSE. print summary only.
c   N     = number of random arguments to be tested for each interval.
c   IDUM  = seed for starting random number generator dran1.
c   IOUT  = unit number for print.
      Parameter      (prall = .FALSE., n = 2000, iout = 6 )
c-----------------------------------------------------------------------
c
c
      xmin = Tiny( 1.0_l_ )
c      xmax = Huge( 1.0_l_ )
c
c --- xmax with a safety factor for Convexes (original value causes
c     sometimes overflow!).
c
      xmax   = Huge( 1.0_l_ )/Real( 128, l_ )
      minexp = Int ( Log10 ( xmin ) )
      maxexp = Int ( Log10 ( xmax ) )
      it     = Radix( 1.0_l_ )
      ibeta  = Digits( 1.0_l_ )
      irnd   = 1
c
c --- Call identification routine.
c
      Call state( 'mod1e   ' )
c
c --- Set seed for random number generator
c
      idumx = -1989
c
      prallx = prall
      nx     = n
      iyx    = iy
      ioutx  = iout
      ibetax = ibeta
      itx    = it
      irndx  = irnd
      minexx = minexp
      maxexx = maxexp
c
      If (prall) Then
         Print 1000
         decdig = Real( it, l_ )*Log10( Real( ibeta, l_ ) )
         Print 2000, ibeta, minexp, xmin, it, maxexp, xmax, irnd,
     &             n, decdig

      End If
      Call summ ( dumarg, 0, dummy, dummy, dummy, dummy, dummy, dummy,
     &            dummy, dummy )
      Call spower
      Call ssqrt
      Call sexp
      Call slog
      Call ssin
      Call stan
      Call sasin
      Call satan
      Call ssinh
      Call stanh
      Call summ( dumarg, -1, dummy, dummy, dummy, dummy, dummy, dummy,
     &           dummy, dummy )
      Call summ( dumarg, -2, dummy, dummy, dummy, dummy, dummy, dummy,
     &           dummy, dummy )
      Print 3000
c-----------------------------------------------------------------------
      Stop
 1000 Format ( //,' Accuracy elementary functions (SCALAR)', 24X,
     &         'Detailed results'/' ', 38('-'), 24X, 16('-')// )
 2000 Format ( ' ibeta =',I3,'   minexp =',I6,'   xmin       =',G16.7/
     &         ' it    =',I3,'   maxexp =',I6,'   xmax       =',G16.7/
     &         ' irnd  =',I3,'           ',6X,'               '      /
     &         ' n  ='   ,I6,'           ',6X,'   Dec.Digits =',F7.3/ )
 3000 Format ( /' E N D  of accuracy elementary functions )'/// )
      End
