      Subroutine oper2( nmult, linc, hash )
! -------------------------------------------------------------------
! --- 'oper2' does a multiplication with a stride in the index of
!     array 'a 'to generate memory bank write conflicts. 'linc' is
!     the stride.
!     'a' is it's own target array; 'sb' is the scalar multiplier.
! -------------------------------------------------------------------
      Use                    numerics
      Use                    sizes !Defines type & size of array 'a'.
      Implicit               None           

      Integer              :: nmult
      Integer*8            :: hash, linc
      Real(l_), Parameter  :: sa = 0.5, sb = 0.5

      Integer*8            :: i, l
! -------------------------------------------------------------------
      Do i = 1, nmult
         l    = Abs( Mod( i*linc, hash ) )
         a(l) = a(i)*sa + a(i+1)*sb
      End Do
! -------------------------------------------------------------------
      End Subroutine oper2
