      Subroutine oper1( sy, nmult, linc, hash )
! -------------------------------------------------------------------
! --- 'oper1' does a multiplication with a stride in the index of
!     array 'a ' to generate memory bank read conflicts. 'linc' is
!     the stride.
!     'sy' is the target variable.
! -------------------------------------------------------------------
      Use                    numerics
      Use                    sizes !Defines type & size of array 'a'.
      Implicit               None

      Integer             :: nmult
      Integer*8           :: hash, linc
      Real(l_)            :: sy

      Real(l_), Parameter :: sa = 0.5, sb = 0.5
      Integer*8           :: i, l
! -------------------------------------------------------------------
      Do i = 1, nmult
         l  = Abs( Mod( i*linc, hash ) )
         sy = a(l)*sa + a(l)*sb
      End Do
! -------------------------------------------------------------------
      End Subroutine oper1
