      Subroutine permut( n, index, iseed )
      Use        numerics
      Implicit   None

      Integer :: n, iseed
      Integer :: index( n )
! ---------------------------------------------------------------------
! --- Purpose
c     =======
!     This routine generates a randomly permuted Integer array in the
!     range 1 ... n.
!
! --- Local Variables
!     ===============
      Integer :: i, j, indexi, jseed
!
! --- External Functions
!     ==================
      External    dran1
      Real(l_) :: dran1
! ---------------------------------------------------------------------
! --- First initialize array index.
      Do i = 1, n
        index(i) = i
      End Do

! --- Permute index randomly
      jseed = iseed
      Do i = 1, n
   10    Continue
         j = Int( dran1( jseed ) * n ) + 1
c
! --- Avoid problematic cases (Just to be sure!)
         If ( j <= 0  .OR. j > n ) Go To 10 !=========>

! --- Exchange index(i) and index(j)
         If (  i /= j ) Then
            indexi   = index(i)
            index(i) = index(j)
            index(j) = indexi
         End If
      End Do
! ---------------------------------------------------------------------
      End Subroutine permut
