      Subroutine timer( kern, n, x1, x2, x3, x4, y, ldy, indj,
     &                  krit, nrep, time )
      Use                  numerics
      Implicit             None

      Integer           :: kern, n, ldy, krit, nrep
      Integer           :: indj(*)
      Real(l_)          :: x1(*), x2(*), x3(*), x4(*), y(ldy,2)
      Real(l_)          :: time
! ----------------------------------------------------------------------
! --- Purpose:
!     ========
!     Measure the execution timings and perfomance Flop/s rate of
!     various (important) kernels

! --- Universal constants
      Real(l_), Parameter :: zero = 0.0_l_, one = 1.0_l_, half = 0.5_l_ 
      Real(l_), Parameter :: c0 = 1.999_l_,  c1 = 0.4449_l_, 
     &                       c2 = 0.4449_l_, c3 = 0.6667_l_,
     &                       c4 = 2.001_l_,  c5 = 0.5001_l_,
     &                       c6 = 2.001_l_,  c7 = 0.5001_l_,
     &                       c8 = 1.999_l_,  c9 = 0.5001_l_

! --- Common to frustrate overoptimisation.
      Real(l_)            :: s(2), ssw
      Common /cfake/         s, ssw

! --- Local variables
      Real(l_)            :: t0, t1, corr
      Integer             :: i, jsw, j, n3, n4
      Integer             :: ind(n)

! --- External functions
      Integer             :: jswitch
      External               jswitch
      Real(l_)            :: wclock
      External               wclock
! ----------------------------------------------------------------------
         If ( kern == 1 ) Then

	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = c0
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for overhead in repetition loop.
            corr = wclock()
            Do j = 1,nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 2 ) Then

	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = x1(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for calling repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 3 ) Then

	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = x1(i) + x2(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 4) Then
!
	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = x1(i) - x2(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = ( t1 - wclock() + corr ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 5 ) Then

	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = x1(i) * x2(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 6 ) Then

	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = x1(i) / x2(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 7 ) Then

	 If ( n > 0 ) Then
            s(1) = zero
            s(2) = zero
            t0 = wclock()
! --- Prevent smart compilers from being too smart ...
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
               ssw = s(jsw)
               Do i = 1, n
                  ssw = ssw + x1(i)*x2(i)
               End Do
               s(jsw) = ssw
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 8 ) Then

	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = y(i,jsw) + c0*x1(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) / nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 9 ) Then

	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! ---  Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = x1(i) + c0*x2(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) / nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 10 ) Then

	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = x1(i)*x2(i) + x3(i)*x4(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If

! ----------------------------------------------------------------------
      Else If ( kern == 11 ) Then

	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! ---  Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
               Do i = 2, n+1
                  y(i,jsw) = x1(i) - y(i-1,jsw)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) / nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 12 ) Then

	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
               Do i = 3,n+2
                  y(i,jsw) = x1(i) + y(i-1,jsw) - y(i-2,jsw)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If

! ----------------------------------------------------------------------
      Else If ( kern == 13 ) Then
!
	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 2,n+1
                  y(i,jsw) = x1(i+1) - 2*x1(i) + x1(i-1)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 14 ) Then

	 If ( n > 0 ) Then
            t0 = wclock()
            Do j = 1, nrep
! ---  Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
              y(i,jsw) = c0 + x1(i)*(c1 + x1(i)*(c2 + x1(i)*(c3 + x1(i)*
     &                  (c4 + x1(i)*(c5 + x1(i)*(c6 + x1(i)*(c7 + x1(i)*
     &                  (c8 + x1(i)*c9))))))))
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 15 ) Then

	 If ( n > 0 ) Then
	    n3 = 3 * n
            t0 = wclock()
            Do j = 1, nrep
! ---  Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n3, 3
                  y(i,jsw) = x1(i) * x2(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 16 ) Then

	 If ( n > 0 ) Then
            n4 = n * 4
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n4, 4
                  y(i,jsw) = x1(i) * x2(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 17 ) Then

	 If ( n > 0 ) Then
	    n3 = 3 * n
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n3, 3
                  y(i,jsw) = x1(i) / x2(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 18 ) Then

	 If ( n > 0 ) Then
            n4 = n * 4
            t0 = wclock()
            Do j = 1, nrep
! - Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n4, 4
                  y(i,jsw) = x1(i) / x2(i)
               End Do
            End Do
            t1 = wclock() - t0

! - Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 19 ) Then

	 If ( n > 0 ) Then
	    n3 = 3 * n
            s(1) = zero
            s(2) = zero
            t0 = wclock()
! --- Prevent smart compilers from being too smart ...
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
               ssw = s(jsw)
               Do i = 1, n3, 3
                  ssw = ssw + x1(i)*x2(i)
               End Do
               s(jsw) = ssw
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 20 ) Then

	 If ( n > 0 ) Then
            n4 = n * 4
            s(1) = zero
            s(2) = zero
            t0 = wclock()
! --- Prevent smart compilers from being too smart ...
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
               ssw = s(jsw)
               Do i = 1, n4, 4
                  ssw = ssw + x1(i)*x2(i)
               End Do
               s(jsw) = ssw
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 21 ) Then

	 If ( n > 0 ) Then
   	    n3 = 3 * n
            t0 = wclock()
! --- Prevent smart compilers from being too smart ...
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n3, 3
                  y(i,jsw) = y(i,jsw) + c0*x1(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 22 ) Then

	 If ( n > 0 ) Then
            n4 = n * 4
            t0 = wclock()
! --- Prevent smart compilers from being too smart ...
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n4, 4
                  y(i,jsw) = y(i,jsw) + c0*x1(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 23 ) Then

	 If ( n > 0 ) Then
	    n3 = 3 * n
            t0 = wclock()
! --- Prevent smart compilers from being too smart ...
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n3, 3
                  y(i,jsw) = x1(i) + c0*x2(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 24 ) Then

	 If ( n > 0 ) Then
            n4 = n * 4
            t0 = wclock()
! ---  Prevent smart compilers from being too smart ...
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n4, 4
                  y(i,jsw) = x1(i) + c0*x2(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 25 ) Then

	 If ( n > 0 ) Then
            Call permut( n, ind, -1990 )
            t0 = wclock()
! --- Prevent smart compilers from being too smart ...
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(ind(i),jsw) = x1(i)
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 26 ) Then

	 If ( n > 0 ) Then
            Call permut( n, ind, -1990 )
            t0 = wclock()
! --- Prevent smart compilers from being too smart ...
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = x1(ind(i))
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 27 ) Then

	 If ( n > 0 ) Then
            Call permut( n, ind, -1990 )
            t0 = wclock()
! --- Prevent smart compilers from being too smart ...
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = x1(ind(i)) * x2(ind(i))
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 28 ) Then

	 If ( n > 0 ) Then
            Call permut( n, ind, -1990 )
            t0 = wclock()
! ---  Prevent smart compilers from being too smart ...
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = x1(ind(i)) / x2(ind(i))
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 29 ) Then

	 If ( n > 0 ) Then
            Call permut( n, ind, -1990 )
            s(1) = zero
            s(2) = zero
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
               ssw = s(jsw)
               Do i = 1, n
                  ssw = ssw + x1(ind(i)) * x2(ind(i))
               End Do
               s(jsw) = ssw
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 30 ) Then

         If ( n > 0 ) Then 
            Call permut( n, ind, -1990 )
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = y(i,jsw) + c0 * x1(ind(i))
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      Else If ( kern == 31 ) Then

	 If ( n > 0 ) Then
            Call permut( n, ind, -1990 )
            t0 = wclock()
            Do j = 1, nrep
! --- Prevent smart compilers from being too smart ...
               jsw = jswitch( krit, indj, j )
!$omp parallel do
               Do i = 1, n
                  y(i,jsw) = x1(ind(i)) + c0 * x2(ind(i))
               End Do
            End Do
            t1 = wclock() - t0

! --- Correct for repetition loop.
            corr = wclock()
            Do j = 1, nrep
               jsw = jswitch( krit, indj, j )
            End Do
            time = (  t1 - wclock() + corr  ) /  nrep
         End If
! ----------------------------------------------------------------------
      End If
! ----------------------------------------------------------------------
      End Subroutine timer
