      Subroutine smxv( ra, ja, na, m, n, lamax, lua, luc, luna, b, c,
     &                 lral, readtim, writim, rbyte, wbyte )
! ----------------------------------------------------------------------
! --- Calculates a chunk of the product c(n) = A(n,m)*b(m) + c(n).
!     The length of this part is at most 'lamax' long.
!     Routine 'smxv' should be called Cieling[n/lamax] times to cover
!     all 'n' entries of vector 'c'.
! --- Matrix A is in 'lsqr-format'. 'c' is stored on disk and is
!     accessed through logical unit 'luc'. The number of column entries
!     per row is stored in array 'na' which is read from logical unit
!     luna. 'ra' and 'ja' are read from unit lua and contain the 
!     non-zero matrix entries and the column indices where they are
!     stored, respectively.
! ----------------------------------------------------------------------
      Use                  numerics
      Implicit             None

      Integer           :: lamax, m, n
      Real(l_)          :: ra(lamax),b(m),c(lamax)
      Real(l_)          :: readtim, writim
      Real(l_)          :: wclock
          
      Integer           :: ja(lamax), na(lamax)
      Integer           :: lral, lua, luc, luna, rbyte, wbyte
! ----------------------------------------------------------------------
! --- Local variables.

      Real(l_) :: iotime
      Integer            :: ios, j, k, l, lra, nra
      Integer, Parameter :: dlen = 8, ilen = 4, clen = dlen + ilen 
! ----------------------------------------------------------------------
! --- Get matrix elements row by row (n of them). 

      iotime = wclock()
      Read( luna ) na
      readtim = readtim + wclock() - iotime
      rbyte = rbyte + ILEN*lamax
      Do j = 1, n
         c(j) = 0.0_l_
         lra = lral + na(j) - 1
         If ( lra <= lamax ) Then
            Do l = lral, lra
               c(j) = c(j) + ra(l)*b(ja(l))
            End Do
            lral = lra + 1
         Else
            nra = lra/lamax
            lra = Mod( lra, lamax )
            Do l = lral, lamax
               c(j) = c(j) + ra(l)*b(ja(l))
            End Do
            If( lra /= 0 ) Then
              iotime = wclock()
              Read( lua, Iostat = ios, Err = 900 ) ra, ja
              readtim = readtim + wclock() - iotime
              rbyte = rbyte + clen*lamax
            End If                    
            Do k = 1, nra - 1
               Do l = 1, lamax
                  c(j) = c(j) + ra(l)*b(ja(l))
               End Do
               iotime = wclock()
               Read( lua, Iostat = ios, Err = 900 ) ra, ja
               readtim = readtim + wclock() - iotime
               rbyte = rbyte + clen*lamax
            End Do
            Do l = 1, lra
               c(j) = c(j) + ra(l)*b(ja(l))
            End Do
            lral = lra + 1
         End If
      End Do
      iotime = wclock()
      Write( luc ) c
      writim = writim + wclock() - iotime
      wbyte  = wbyte + dlen*lamax
! ----------------------------------------------------------------------
      Return
! ----------------------------------------------------------------------
  900 Print 1000, lua, ios
 1000 Format ( //,'Input/output error on unit ', I3, ' iostat = ', I7 )
      Stop
      End
