      Subroutine drsmxv( ra, ja, na, m, n, lamax, lua, luc, luna, b, c,
     &                   ioread, iowrit )
! ----------------------------------------------------------------------
      Use         numerics
      Implicit    None           

! --- Calculates the product c(n)  =  A(n,m)*b(m) + c(n).
!     Matrix A is in 'lsqr-format'.
!     'c' is stored on disk and is accessed through logical unit 'luc'.
!     The number of column entries per row is stored in array 'na' 
!     which is read from logical unit luna.

      Integer  :: lamax, m, n
      Real(l_) :: ra(lamax),b(m),c(lamax)
      Real(l_) :: ioread, iowrit, readtim, writim, iotime
      Real(l_) :: wclock          
      Integer  :: ja(lamax), na(lamax)
      Integer  :: lua, luc, luna, rbyte, wbyte
! ----------------------------------------------------------------------
! --- Local variables.

      Real(l_), Parameter :: zero = 0.0_l_, micro = 1.0e-6_l_,
     &                       nano = 1.0e-9_l_
      Integer             :: ios, j, l, llna, lral, nflor, nrest
      Integer, Parameter  :: clen = 12
! ----------------------------------------------------------------------
! --- Initialize.
!
      nflor   = n/lamax
      nrest   = Mod ( n, lamax )
      rbyte   = 0
      wbyte   = 0
      readtim = zero
      writim  = zero
      lral    = 1

      Rewind luna
      Rewind lua
      Rewind luc

      iotime  = wclock()
      Read( lua, Iostat  =  ios, Err  =  900 ) ra, ja
      readtim = readtim + wclock() - iotime
      rbyte   = rbyte + clen*lamax
! ----------------------------------------------------------------------
! --- Get matrix elements row by row (n of them) in chunks of 'lamax'.

      Do j = 1, nflor
         Call smxv( ra, ja, na, m, lamax, lamax, lua, luc, luna, b, c,
     &              lral, readtim, writim, rbyte, wbyte )
      End Do
      Call smxv( ra, ja, na, m, nrest, lamax, lua, luc, luna, b, c,
     &           lral, readtim, writim, rbyte, wbyte )  
! ----------------------------------------------------------------------
! --- Compute read and write rates.

      ioread = micro*Max( Real( rbyte, l_ )/readtim, nano )
      iowrit = micro*Max( Real( wbyte, l_ )/writim,  nano )

! ----------------------------------------------------------------------
      Return
  900 Print 1000, lua, ios
 1000 Format ( //,'Input/output error on unit ', I3, ' iostat = ', I7 )
      Stop
      End
