      Program mod2h
! **********************************************************************
! *** This program is part of the EuroBen Benchmark                  ***
! ***                                                                ***
! *** Copyright: EuroBen Group p/o                                   ***
! ***            Utrecht University, Computational Physics Dept.     ***
! ***            P.O. Box 80.000                                     ***
! ***            3508 TA Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Authors of this program: Aad van der Steen                     ***
! *** Date                    Spring 2003                            ***
! *** Adjustments of timing resolution and  problem set              ***
! *** by Aad van der Steen    Fall   2003                            ***
! **********************************************************************
!  Distributed Version 1.0
!
! --- EuroBen Benchmark Module 2h. Computes uniformly distributed random
!     numbers in the interval [0,1).
! ----------------------------------------------------------------------
      Use                      numerics
      Use                      ran_module
      Implicit                 None
      
      Real(l_), Allocatable :: a(:)
      Real(l_)              :: timebf, time
      Integer               :: n, nsize, ops
      Real(l_)              :: nops
      Logical               :: ok

      Real(l_)              :: wclock
      External                 wclock
! ----------------------------------------------------------------------
! --- Call identification routine.

      Call state( 'mod2h   ' )
! ----------------------------------------------------------------------
! --- Fill A with random numbers and include initialisation overhead
!     in the timing.

      Print 1000
      Open( 1, File = 'mod2h.in' )
   10 Read( 1, *, End = 20 ) nsize 
      n  = nsize 
      Allocate( a(n) )
      x1 = 2003                          ! --- Seeds for random process.
      x2 = 2017
      timebf = wclock()
      Call rinit
      Call ranfil( a, n )
      time = wclock() - timebf
      ok   = .TRUE.
      Call check( a, n, ok )
      ops = 9*nsize
      nops = 1.0e-6_l_*ops/Max( time, 1.0e-15_l_ )
      Print 1010, nsize, time, nops, ok
      Deallocate( a )
      Go To 10
   20 Print 1020
! ----------------------------------------------------------------------
 1000 Format(' Machine-independent random number generator dran0'/
     &       ' (including initialisation)'/
     &       '----------------------------------------'/
     &       '   Size |   Time(s)   |   Mop/s     |OK|'/
     &       '----------------------------------------' )
 1010 Format( i8, '|', g13.5, '|', g13.5, '|', l2, '|' )
 1020 Format('----------------------------------------' )
! ----------------------------------------------------------------------
      End Program mod2h
