      Subroutine check( a, n, ok )
! ---------------------------------------------------------------------
! --- Routine 'check' checks the correctness of the parallelly
!     generated random numbers by comparing them to a small sample
!     of the sequentially generated numbers.
! ---------------------------------------------------------------------
      Use                      numerics
      Use                      ran_module
      Implicit                 None

      Integer               :: n
      Real(l_)              :: a(n)
      Logical               :: ok

      Real(l_)              :: eps, testnum
      Integer               :: i
      
      Real(l_)              :: dran0
      External                 dran0
! ---------------------------------------------------------------------
      eps = 10.0_l_*Epsilon( 1.0_l_ )
      x1 = 2003
      x2 = 2017
      Do i = 1, 97
         x1 = Mod( a1*x1 + c1, m1 )
         x2 = Mod( a2*x2 + c2, m2 )
      End Do
      Do i = 1, n
         testnum = dran0()
      End Do
      ok = ok .AND. ( Abs( testnum - a(n) ) <= eps )
! ---------------------------------------------------------------------
      End Subroutine check

