      Program mod2f
! **********************************************************************
! *** This program is part of the EuroBen Benchmark                  ***
! ***                                                                ***
! *** Copyright: EuroBen Benchmark Group p/o                         ***
! ***            Academic Computing Centre Utrecht                   ***
! ***            P.O. Box 80.011                                     ***
! ***            3508 TA Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Aad van der Steen                      ***
! *** Date Version 1.0        Summer 1996                            ***
! *** Date Version 1.1        Autumn 1998                            ***
! *** Date Version 2.0        Autumn 2005                            ***
! **********************************************************************
!  ======================
!  Sequential Version 2.0
!  ======================
! ----------------------------------------------------------------------
! --- Program 'mod2f' measures the speed of a parallel 1-D 
!     complex-to-complex FFT on one processor.
!     A radix-4 algorithm with loop inversion is used.
!     The generation and storage of the
!     twiddle factors follow an idea of Dave Bailey (The Journal of
!     Supercomputing, Vol. 1, No.1, 43--60, 1987).
! ----------------------------------------------------------------------
!     Parameters:
!
!     N       -- Length of FFT.
!     M       -- 2-Logarithm of the length N.
! ----------------------------------------------------------------------
      Use                   numerics
      Implicit              None

      Real(l_), Allocatable :: a(:),  b(:), c(:), ur(:), ui(:),
     &                         wr(:), wi(:)
      Real(l_)              :: time
      Integer               :: m, n
      Real(l_)              :: corr, err, wclock
      Real(l_)              :: rmflint, rmfltrn, mflops
      Integer               :: irep, mflint, mfltrn, mfltot, nrep
      Logical               :: ok
! ----------------------------------------------------------------------
! --- Call identification routine.

      Call state( 'mod2f   ' )
      Print 1000
! ----------------------------------------------------------------------
! --- Read problem sizes and initialise arrays.

      Open ( 1, File = 'mod2f.in' )
   10 Read ( 1, *, End = 20 ) m, nrep
      n = 2**m
! -----------------------------------------------------------------------
! --- Check that the number of processors is a power of 2.

      err = ( 10.0_l_*n*m ) * 1.0e-10_l_
      Allocate( a(n), b(n), c(n), ur(n), ui(n), wr(n), wi(n) )
      Call datgen( c, n )
! ----------------------------------------------------------------------
! --- Repeat FFT 'nrep' times for this problem size.

      time = wclock()
      Do irep = 1, nrep
         a = c
         b = 0.0_l_
         Call cfft4( 0, m, ur, ui, a, b, wr, wi )
         Call cfft4( 1, m, ur, ui, a, b, wr, wi )
      End Do
      time = wclock() - time
! ----------------------------------------------------------------------
! --- Check for errors and correct timing for filling of arrays.

      Call errchk( a, b, n, err, ok )
      corr = wclock()
      Do irep = 1, nrep
         a = c
         b = 0.0_l_
      End Do
      corr = wclock() - corr
      time = ( time - corr )/ Real( nrep, l_ )
! ----------------------------------------------------------------------
! --- Calculate Mflop rates.     

      Call nflops( m, mflint, mfltrn )
      mflops = 1.0e-6_l_*( mfltrn + mflint )/time
      Print 1010, n, time, mflops, ok
      Deallocate( a, b, c, ur, ui, wr, wi )
! ----------------------------------------------------------------------
! --- Get new problem.

      Go To 10
! ----------------------------------------------------------------------
! --- End of measurements: report results.

   20 Print 1020
! ----------------------------------------------------------------------
 1000 Format( 'Program mod2f computes 1-D, complex-to-complex FFTs:'/
     &        '----------------------------------------------------'/ 
     &         '        FFT results, Radix-4 algorithm',/
     &         '-----------------------------------------------'/
     &         ' Length |  Total Time  |    Speed     | Check |'/
     &         '   N =  |     (sec)    |  (Mflop/s)   |   OK  |'/
     &         '-----------------------------------------------' )
 1010 Format ( i8, '| ', g13.5, '| ', g13.5, '| ',   l3, 3x, '|' )
 1020 Format ( '-----------------------------------------------' )
! ----------------------------------------------------------------------
      End Program mod2f
