      Subroutine datgen( a, n )
! ----------------------------------------------------------------------
! --- Routine 'datgen' generates the Real part of the test data for
!     the FFT: One complete cosine cycle in the Real part of the data.
! ----------------------------------------------------------------------
      Use              numerics
      Implicit         None

      Integer       :: n
      Real(l_)      :: a(0:n-1)

      Integer       :: i
      Real(l_)      :: fac
! ----------------------------------------------------------------------
      fac   = 8.0_l_*Atan( 1.0_l_ )/Real( n, l_ )
      Do i = 0, n - 1
         a(i) = Cos( i*fac )
      End Do
! ----------------------------------------------------------------------
      End Subroutine datgen 
