      Function wclock()                               Result (walltime)
      Use numerics
      Implicit None

! --- Function 'wclock()' gives wall-clock time in seconds. 
!     The function used here is the system routine 'gettimeofday'
!     through the routine 'cclock'. 
! --- An alternative is to use the Fortran 90 system intrinsic
!     'system_clock' when the count_rate is sufficiently high.
!     This can be tested with the test program 'tstclk'.
!     If 'system_clock' is used: comment out line 23 and
!     decomment lines 25--26.
! --- One can also use a system specific clock routine when the 
!     resolution is better: comment out line 23, decomment line
!     28 and replace 'your_clock' by your preferred clock routine
!     and adjust line 18.

      Real(l_) :: walltime, cclock !, your_clock
      Integer  :: count, count_rate

! ----------------------------------------------------------------------

      walltime = cclock()

!     Call system_clock ( count, count_rate )
!     walltime = Real( count, l_ )/Real( count_rate, l_ )

!     walltime = your_clock

! ----------------------------------------------------------------------
      End Function wclock
