      Subroutine sym7mxv( n1, n2, n3, a, x, y )
! ---------------------------------------------------------------------
! --- sym7mxv does a matrix-vector multiply of a banded symmetric
!     matrix originating from a 3-D finite difference scheme. Only
!     the upper diagonal part of matrix a is stored in a(*,0:3).
! ---------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Implicit    None

      Integer  :: n1 ,n2 ,n3
      Real(l_) :: a(n1*n2*n3,0:3), x(n1*n2*n3), y(n1*n2*n3)

      Integer  :: i, ntot, n12
! ---------------------------------------------------------------------
      n12  = n1*n2
      ntot = n12*n3
      y(1) = a(1,0)*x(1) + a(1,1)*x(2) + a(1,2)*x(n1+1) + 
     &       a(1,3)*x(n12+1)
      Do i = 2, n1
         y(i) = a(i,0)*x(i)     + a(i,1)*x(i+1)   + a(i,2)*x(i+n1) +
     &          a(i,3)*x(i+n12) + a(i-1,1)*x(i-1)
      End Do
      Do i = n1+1, n12
         y(i) = a(i,0)*x(i)     + a(i,1)*x(i+1)   + a(i,2)*x(i+n1) +
     &          a(i,3)*x(i+n12) + a(i-1,1)*x(i-1) + a(i-n1,2)*x(i-n1)
      End Do
      Do i = n12 + 1, ntot - n12
         y(i) = a(i,0)*x(i)     + a(i,1)*x(i+1)   + a(i,2)*x(i+n1) +
     &          a(i,3)*x(i+n12) + a(i-1,1)*x(i-1) + a(i-n1,2)*x(i-n1) +
     &          a(i-n12,3)*x(i-n12)
      End Do
      Do i = ntot - n12 + 1, ntot - n1
         y(i) = a(i,0)*x(i)     + a(i,1)*x(i+1)   + a(i,2)*x(i+n1) +
     &          a(i-1,1)*x(i-1) + a(i-n1,2)*x(i-n1) +
     &          a(i-n12,3)*x(i-n12)
      End Do
      Do i = ntot - n1 + 1, ntot - 1
         y(i) = a(i,0)*x(i)       + a(i,1)*x(i+1) + a(i-1,1)*x(i-1) +
     &          a(i-n1,2)*x(i-n1) + a(i-n12,3)*x(i-n12)
      End Do
      y(ntot) = a(ntot,0)*x(ntot)       + a(ntot-1,1)*x(ntot-1) +
     &          a(ntot-n1,2)*x(ntot-n1) + a(ntot-n12,3)*x(ntot-n12)

      flops = flops + 14 + 18*( n1 - 1 ) + 22*n1*( n2 - 1 ) +
     &                13*( n1*n2*( n3 - 2 ) ) ! -- Keep track of flops.
! ---------------------------------------------------------------------
      End Subroutine sym7mxv
