      Subroutine mvddot( a, b, c, lda, m, n )
! ----------------------------------------------------------------------
! --- Routine 'mvddot' does a matrix-vector multiplication 'Ab = c'
!     using a dotproduct implementation.
! ----------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: lda, m, n
      Real(l_) :: a(lda,n), b(n), c(m)

      Integer  :: i, j, nf
      Real(l_) :: t(4)
! ----------------------------------------------------------------------
      nf = n - Mod( n, 4 )
      Do i = 1, m
         t(1) = 0.0_l_; t(2) = 0.0_l_;t(3) = 0.0_l_;t(4) = 0.0_l_
         Do j = 1, nf, 4
         t(1) = t(1) + a(i,j)  *b(j)
         t(2) = t(2) + a(i,j+1)*b(j+1)
         t(3) = t(3) + a(i,j+2)*b(j+2)
         t(4) = t(4) + a(i,j+3)*b(j+3)
         End Do
         c(i) = t(1) + t(2) + t(3) + t(4)
      End Do
      c(nf+1:m) = 0.0_l_
      Do j = nf + 1, n
         c(1:m) = c(1:m) + a(1:m,j)*b(j)
      End Do
! ----------------------------------------------------------------------
      End Subroutine mvddot
