      Subroutine mvaxpy( a, b, c, lda, m, n )
! ----------------------------------------------------------------------
! --- Routine 'mvaxpy' does a matrix-vector multiplication 'Ab = c'
!     using a vector update implementation.
! ----------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: lda, m, n
      Real(l_) :: a(lda,n), b(n), c(m)

      Integer  :: i, j, nf
! ----------------------------------------------------------------------
      c  = 0.0_l_
      nf = n - Mod( n, 4 )
      Do j = 1, nf, 4
         Do i = 1, m
         c(i) = c(i) + a(i,j)*b(j)     + a(i,j+1)*b(j+1)
     &               + a(i,j+2)*b(j+2) + a(i,j+3)*b(j+3)
         End Do
      End Do
      Do j = nf + 1, n
         c(1:m) = c(1:m) + a(1:m,j)*b(j)
      End Do
! ----------------------------------------------------------------------
      End Subroutine mvaxpy
