      Program mod2a
! ----------------------------------------------------------------------
! **********************************************************************
! *** This program is part of the EuroBen Benchmark                  ***
! ***                                                                ***
! *** Copyright: EuroBen (European Benchmark Group)                  ***
! *** Distribution by:                                               ***
! ***            Utrecht University, Computational Physics Dept.     ***
! ***            P.O. Box 80.000                                     ***
! ***            3508 TA Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Aad van der Steen                      ***
! *** Contributed             Summer 1990                            ***
! *** Last Modified           November 2001 by Aad van der Steen     ***
! ***                         (To incorporate OpenMP)                ***
! **********************************************************************
! Version 4.0
!
! --- Program 'mod2a' does a full matrix-vector multiplication in two
!     ways: dotproduct and vector-update.
!     The size of the matrix and vector are read and they are generated
!     internally.
! ----------------------------------------------------------------------
      Use                      numerics
      Implicit                 None

      Real(l_), Allocatable :: a(:,:), b(:), c(:)
      Integer               :: i, lda, m, n, nops, nrep
      Real(l_)              :: speed1, time1, speed2, time2, wclock
      Logical               :: ok1, ok2
! ----------------------------------------------------------------------
      Call state( 'mod2a   ' )
      Open( 1, File = 'mod2a.in' )
      Print 1000
   10 Read( 1, *, End = 20 ) m, n, nrep
      lda = m + 1
      Allocate( a(lda,n), b(n), c(m) )
      nops = 2*m*n
      Call gendat( a, b, lda, m, n )       ! --- Generate data.

      time1 = wclock()                     ! --- Time MxV mult.
      Do i  = 1, nrep
         Call mvddot( a, b, c, lda, m, n )
      End Do
      time1 = wclock() - time1
      ok1 = .TRUE.
      Call check( c, m, n, ok1 )           ! --- Correctness check.
      time2 = wclock()                        
      Do i  = 1, nrep
         Call mvaxpy( a, b, c, lda, m, n )
      End Do
      time2 = wclock() - time2
      ok2 = .TRUE.
      Call check( c, m, n, ok2 )           ! --- Correctness check.

      speed1 = 1.0e-6_l_*((1.0_l_*nrep)*nops)/Max( time1, 1.0e-9_l_ )
      speed2 = 1.0e-6_l_*((1.0_l_*nrep)*nops)/Max( time2, 1.0e-9_l_ )
      Print 1010, n, m, time1/nrep, speed1, ok1, time2/nrep, speed2,
     &            ok2
      Deallocate( a, b, c )
      Go To 10
   20 Print 1020
! ---------------------------------------------------------------------
 1000 Format( 'Matrix-vector multiplication test:'/
     &        '-----------------------------------------------------',
     &        '-------------------------'/,
     &        ' Problem size|  MxV-ddot  |  MxV-ddot  |     |',
     &        '   MxV-axpy |  MxV-axpy  |     |'/,
     &        '   m  |   n  |  Time (s)  |  (Mflop/s) | OK? |',
     &        '  Time (s)  |  (Mflop/s) | OK? |'/, 
     &        '-----------------------------------------------------',
     &        '-------------------------' )
 1010 Format( I5, ' |', I5, ' |', G11.4,' |', G11.4, ' |', L3, '  |',
     &        G11.4,' |', G11.4, ' |', L3, '  |' )
 1020 Format( '-----------------------------------------------------',
     &        '-------------------------' )
! ----------------------------------------------------------------------
      End Program mod2a
