      Program mod1f
! ----------------------------------------------------------------------
! **********************************************************************
! *** This program is part of the EuroBen Benchmark                  ***
! ***                                                                ***
! *** Copyright: EuroBen (European Benchmark Group)                  ***
! *** Distribution by:                                               ***
! ***            Utrecht University, Computational Physics Dept.     ***
! ***            P.O. Box 80.000                                     ***
! ***            3508 TA Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Armin Friedli                          ***
! ***                         Institut fuer Angew. Mathematik  FLI   ***
! ***                         ETH-Zentrum, CH-8092, Zurich           ***
! *** Contributed             Summer 1990                            ***
! *** Last Modified           November 2001 by Aad van der Steen     ***
! **********************************************************************
!  Version 4.0
!
!- Purpose of module 1f
!  --------------------
!   Timing tests for the elementary functions (64-bits precision).
!
!   The elementary functions as provided by Fortran-90 are timed.
!   The intervals for the arguments for the various functions
!   are the ones used in the ELEFUNT package, a collection of programs
!   to test the accuracy of the elementary functions, by W.J. Cody and
!   W. Waite.
!
!   The results are printed on to unit 6 (assumed to be standard 
!   output), and also (in a more concise form) onto unit 10; 
!   this file should be saved if postprocessing (graphical display
!   of performance) of results is intended.
! ----------------------------------------------------------------------
      Use                   numerics
      Implicit              None

      Integer, Parameter :: mrep = 20 000, nfmax = 100, nmax = 50,
     &                      nn = 34
                            
      Real(l_)           :: beta, xmin, xmax, xint(nfmax,2), yint(2)
      Real(l_)           :: tab(nfmax,nmax)
      Integer            :: i, it, iy, maxi
      Integer            :: narr(nmax)
      Character*8        :: ident(nfmax)

      Common /blmach/       xmin, xmax, beta, it
      Common /ran1iy/       iy
! --- Common to frustrate overoptimisation:
      Real(l_)           :: f(30000)
      Common /cfake/        f
!----------------------------------------------------------------------
!
! --- Before running this benchmark program, check the following...
!     *************************************************************
!
!   - 'lout' defines the standard output unit number.
!   - 'iy' defines the starting seed for the random number generator.
!   - 'xmax' may have to be set smaller than its theoretical value
!     (for example when testing the exp function, the arguments may get
!      too large).
!-----------------------------------------------------------------------
! --- Set values of 'narr' (the array containing the vectorlengths
!     to be tested). These values are specified for NN entries,
!     the other nn+1,...,nmax (= 50 at this moment) values are set to 0.

      Data narr/    1,     2,     3,     4,     5,     6,     7,     8,
     1              9,    10,    20,    30,    40,    50,    60,    70,
     2             80,    90,   100,   200,   300,   400,   500,   600,
     3            700,   800,   900,  1000,  2000,  4000,  6000,  8000,
     4          10000, 20000,     0,     0,     0,     0,     0,     0,
     5              0,     0,     0,     0,     0,     0,     0,     0,
     6              0,     0/
!-----------------------------------------------------------------------
!
! --- Call identification routine.
!
      Call state('mod1f   ')
!
!-----------------------------------------------------------------------
! --- Define the machine dependent constants XMIN, XMAX, IT, BETA.
!     XMIN --- Smallest nonvanishing floating point number of the radix.
!     XMAX --- Largest finite floating point number.
!     IT   --- Number of base-BETA digits in significand of a FP-number.
!     BETA --- Radix of the floating-point system.
!-----------------------------------------------------------------------
      xmin = Tiny( 1.0_l_ )
      xmax = Huge( 1.0_l_ )
      it   = Digits( 1.0_l_ )
      beta = Radix( 1.0_l_ )
!-----------------------------------------------------------------------
! --- Set seed for random generator.
!
      iy = -2001
!----------------------------------------------------------------------
! --- Compute results and print.

      maxi = 100
      Call efvec( maxi, mrep, tab, nn, narr, ident, xint, yint )
      Call wrtab( maxi, tab, nn, narr, ident, xint, yint )

      Print *, '   '
      Print *, ' ---------- E n d   o f   T e s t -------------'
      Print *, ' --- NOTE: n1/2 is only rough approximation ---'
      Print *, ' ----------------------------------------------'
!   --------------------------------------------------------------------
      End Program mod1f
