      Function dran1( idum )                         Result( ran )
      Use        numerics
      Implicit   None

      Integer :: idum
! -----------------------------------------------------------------
! --- dran1 returns a uniform deviate in (0,1).
!
! --- The algorithm is taken from Press & Teukolsky et.al. and
!     based on the linear congruential method  with choices for
!     M, IA, and IC that are given by D. Knuth in "Semi-numerical
!     algorithms.
!
! --- Input-parameters:
!     Integer - idum. When idum < 0 the sequence of random values
!                     When idum >= 0, DRAN1 returns the next value
!                     in the sequence. When DRAN1 is called for
!                     the first time it is also initialised.
!
! --- Output-parameters:
!     Integer  - idum. Next value of seed as produced by DRAN1.
!     Real(l_) - ran.  Uniform deviate in (0,1)
! ------------------------------------------------------------------
!
      Real(l_)            :: ran, r(97)
      Integer             :: iff, ix1, ix2, ix3, j
! ------------------------------------------------------------------
! --- Definitions of the three linear congruences used in generating
!     the random number.

      Integer, Parameter  :: m1 = 259200, ia1 = 7141, ic1 = 54773,
     &                       m2 = 134456, ia2 = 8121, ic2 = 28411,
     &                       m3 = 243000, ia3 = 4561, ic3 = 51349
      Real(l_), Parameter :: one = 1.0_l_, rm1 = one/m1,
     &                       rm2 = one/m2
!
      Save             iff, r, ix1, ix2, ix3
      Data             iff/0/
! ------------------------------------------------------------------
! --- (Re)initialise if required.

      If( idum < 0 .OR. iff == 0 ) Then
         iff = 1
! ------------------------------------------------------------------
! --- Seed first generator.
	 
	 ix1 = Mod( ic1 - idum, m1 ) 
	 ix1 = Mod( ia1*ix1 + ic1, m1 )
! ------------------------------------------------------------------
! --- Use it to seed the second generator.
 
         ix2 = Mod( ix1, m2 )
         ix1 = Mod( ia1*ix1 + ic1, m1 )
! -----------------------------------------------------------------
! --- Use generator 1 again to seed generator 3.

         ix3 = Mod( ia1*ix1, m3 )
! -----------------------------------------------------------------
! --- Now fill array with random values, using gen. 2 for the high
!     order bits and gen. 1 for the low order bits.

         Do j = 1,97
            ix1 = Mod( ia1*ix1 + ic1, m1 )
	    ix2 = Mod( ia2*ix2 + ic2, m2 )
            r(j) = ( Real( ix1, l_ ) + Real( ix2, l_ )*rm2 )*rm1
         End Do
         idum = 1
      End If
! -----------------------------------------------------------------
! --- This section is only reached when no (re)initialisation takes
!     place. A new random number is generated to fill the place of
!     a randomly picked element from array R (the selection of the
!     index is done by gen. 3).

      ix1 = Mod( ia1*ix1 + ic1, m1 )
      ix2 = Mod( ia2*ix2 + ic2, m2 )
      ix3 = Mod( ia3*ix3 + ic3, m3 )
      j   = 1 + (97 + ix3)/m3
      ran = r(j)
      r(j) = ( Real( ix1, l_ ) + Real( ix2, l_ )*rm2 )*rm1
! -----------------------------------------------------------------
      End Function dran1
