      Subroutine ssqrt
      Implicit None
      External dran1, summ
      Common /blmaco/ ibeta, idum, it, irnd, minexp, maxexp, xmin, xmax
      Common /blprnt/ prall, iout, n
      Logical prall
c
c     Program to test Sqrt.
c
c --- Data required:
c
c        None
c
c --- Subprograms required from this package:
c
c                 IBETA         - The radix of the floating-point
c                                 system.
c                 IT            - The number of base-ibeta digits in
c                                 the significand of a floating-point
c                                 number.
c                 IRND          - 0 if floating-point addition chops,
c                                 1 if floating-point addition rounds.
c                 dran1( idum ) - A function subprogram returning
c                                 random _REAL_ numbers uniformly             
c                                 distributed over (0,1)
c
c --- Standard FORTRAN subprograms required:
c
c         Abs,  Log,  Max ,  Dble, Sqrt
c
c
c --- Latest revision - December 6, 1979
c
c --- Author - W. J. Cody
c              Argonne National Laboratory
c
c ----------------------------------------------------------------------
      Integer          i, ibeta, iexp, iout, irnd, it, i1, j, k, k1,
     &                 k2, k3, l, m, machep, maxexp, minexp, n, negep,
     &                 ngrd, idum
      Double Precision a, ait, albeta, b, beta, c, one, randl, r6, r7,
     &                 sqbeta, w, x, xmax, xmin, xn, x1, y, z, zero,
     &                 dummy
      Character*8      char(2)
c
      char(1) = 'Sqrt(xsq)'
      char(2) = 'Sqrt(xsq)'
c
      beta    = Dble ( ibeta )
      sqbeta  = Sqrt ( beta )
      albeta  = Log ( beta )
      ait     = Dble(it)
      one     = 1.0D0
      zero    = 0.0D0
      a       = one / sqbeta
      b       = one
      xn      = Dble( n )
c-----------------------------------------------------------------
c     Random argument accuracy tests.
c-----------------------------------------------------------------
      Do j = 1, 2
         c = Log ( b/a )
         k1 = 0
         k3 = 0
         x1 = zero
         r6 = zero
         r7 = zero
c
         Do i = 1, n
            x = a * randl ( c )
            y = x * x
            z = Sqrt ( y )
            w = ( z - x ) / x
            If ( w .GT. zero ) k1 = k1 + 1
            If ( w .LT. zero ) k3 = k3 + 1
            w = Abs ( w )
            If ( w .le. r6 ) Go To 120
            r6 = w
            x1 = x
  120       r7 = r7 + w * w
         End Do
c
         k2 = n - k1 - k3
         r7 = Sqrt ( r7/xn )
         If ( prall ) Print 1000 
         If ( prall ) Print 1010, n, a, b
         If ( prall ) Print 1011, k1, k2, k3
         If ( prall ) Print 1020, it, ibeta
         w = -999.0D0
         If ( r6 .NE. zero ) w = Log ( Abs ( r6 ) )/albeta
         If ( prall ) Print 1021, r6, ibeta, w, x1
         w =  Max ( ait + w, zero )
         If ( prall ) Print 1022, ibeta, w
         w = -999.0D0
         If ( r7 .NE. zero ) w = Log ( Abs ( r7 ) )/albeta
         If ( prall) Print 1023, r7, ibeta, w
         w =  Max ( ait + w, zero )
         If ( prall ) Print 1022, ibeta, w
         Call summ ( char(j), j, r6, r7, a, b, dummy, dummy, x1,
     &               dummy )
         a = one
         b = sqbeta
      End Do
      If ( prall ) Print 1100
c ----------------------------------------------------------------------
      Return
 1000 Format ( '1Test of Sqrt(x*x) - x '// )
 1010 Format ( I7,' Random arguments were tested from the interval '/
     & 6X,'(',E15.4,',',E15.4,')'//)
 1011 Format ( ' Sqrt(x) was larger',I6,' times', /
     &     12X,' agreed',I6,' times, and '/
     &     8X,'was smaller',I6,' times.'//)
 1020 Format ( ' There are',I4,' base',I4,
     &    ' significant digits in a floating-point number  '//)
 1021 Format ( ' The maximum relative error of',E15.4,' = ',I4,' **',
     &  F7.2/4X,'occurred for x =',E17.6)
 1022 Format ( ' The estimated loss of base',I4,
     &  ' significant digits is',F7.2//)
 1023 Format ( ' The root mean square relative error was',E15.4,
     &    ' = ',I4,' **',F7.2)
 1100 Format ( ' This concludes the tests ')
c ----------------------------------------------------------------------
      End
