      Subroutine ssinh
      Implicit None
      External dran1, summ
      Common /blmaco/ ibeta, idum, it, irnd, minexp, maxexp, xmin, xmax
      Common /blprnt/ prall, iout, n
      Logical prall
c
c --- program to test sinh/cosh.
c
c --- Data required:
c
c        None
c
c --- Subprograms required from this package:
c
c                 IBETA         - The radix of the floating-point
c                                 system.
c                 IT            - The number of base-ibeta digits in
c                                 the significand of a floating-point
c                                 number.
c                 IRND          - 0 if floating-point addition chops,
c                                 1 if floating-point addition rounds.
c                 dran1( idum ) - A function subprogram returning
c                                 random _REAL_ numbers uniformly             
c                                 distributed over (0,1)
c
c --- Standard FORTRAN subprograms required:
c
c         Abs,  Log,  Max , Cosh,  Dble, Int, Sinh, Sqrt
c
c
c --- Latest revision - December 6, 1979
c
c --- Author - W. J. Cody
c              Argonne National Laboratory
c
c ----------------------------------------------------------------------
      Integer          i, ibeta, iexp, ii, iout, irnd, it, i1, i2, j, k,
     &                 k1, k2, k3, l, m, machep, maxexp, minexp, n, 
     &                 negep, ngrd, nit, idum
      Double Precision a, aind, ait, albeta, alxmax, b, beta, betap,
     &                 c, c0, del, den, epslon, five, one, dran1,
     &                 r6, r7, three, w, x, xl, xmax, xmin ,xn, x1, 
     &                 xsq, y, z, zero, zz, dummy
      Character*8 char(4)
c
      char(1) = 'Sinh(x)'
      char(2) = 'Cosh(x)'
      char(3) = 'Sinh(x)'
      char(4) = 'Cosh(x)'
c
      beta    =  Dble ( ibeta )
      albeta  =  Log ( beta )
      alxmax  =  Log ( xmax ) - 0.5D0
      ait     =  Dble ( it )
      zero    = 0.0D0
      one     = 1.0D0
      three   = 3.0D0
      five    = 5.0D0
      c0      = five/16.0D0 +
     &          1.15271368319426997874886766130751616D-2
      a       = zero
      b       = 0.5D0
      c       = ( ait + one ) * 0.35D0
      If ( ibeta .eq. 10 ) c = c*three

      xn      =  Dble ( n )
      i1      = 0
      i2      = 2
      epslon  = Dble( ibeta )**( 1 - it )/2.0D0
      nit     = 2 - ( Int ( Log ( epslon )*three ) )/20
      aind    =  Dble( nit + nit + 1 )
c-----------------------------------------------------------------
c     Random argument accuracy tests.
c-----------------------------------------------------------------
      Do j = 1, 4
         If ( j .NE.  2 ) Go To 30
         aind = aind - one
         i2 = 1
   30    k1 = 0
         k3 = 0
         x1 = zero
         r6 = zero
         r7 = zero
         del = ( b - a ) / xn
         xl = a
c
         Do i = 1, n
            x = del*dran1 ( idum ) + xl
            If ( j .GT.  2 ) Go To 80
            xsq = x * x
            zz = one
            den = aind
c
            Do ii = i2, nit
               w = zz*xsq/( den*( den - one ) )
               zz = w + one
               den = den - 2.0D0
            End Do
c
            If ( j .EQ.  2 ) Go To 50
            w = x*xsq*zz/6.0D0
            zz = x + w
            z = Sinh(x)
            If ( irnd .NE. 0 ) Go To 110
            w = ( x - zz ) + w
            zz = zz + ( w + w )
            Go To 110
   50       z = Cosh(x)
            If ( irnd .NE. 0 ) Go To 110
            w = ( one - zz) + w
            zz = zz + ( w + w )
            Go To 110
   80       y = x
            x = y - one
            w = x - one
            If ( j .EQ. 4 ) Go To 100
            z  =   Sinh ( x )
            zz = ( Sinh ( y ) + Sinh ( w ) )*c0
            Go To 110
  100       z  =   Cosh ( x )
            zz = ( Cosh ( y ) + Cosh ( w ) )*c0
  110       w = one
            If ( z .NE. zero ) w = ( z - zz )/z
            If ( w .GT. zero ) k1 = k1 + 1
            If ( w .LT. zero ) k3 = k3 + 1
            w = Abs ( w )
            If ( w .LE. r6 ) Go To 120
            r6 = w
            x1 = x
  120       r7 = r7 + w*w
            xl = xl + del
         End Do
c
         k2 = n - k3 - k1
         r7 = Sqrt ( r7/xn )
         i = (j/2) * 2
         If ( j .EQ. 1 .AND. prall ) Print 1000 
         If ( j .EQ. 2 .AND. prall ) Print 1005 
         If ( j .EQ. 3 .AND. prall ) Print 1001 
         If ( j .EQ. 4 .AND. prall ) Print 1006 
         If ( prall ) Print 1010, n, a, b
         If ( i .NE. j .AND. prall ) Print  1011, k1, k2, k3
         If ( i .EQ. j .AND. prall ) Print  1012, k1, k2, k3
         If ( prall ) Print 1020, it, ibeta
         w = -999.0D0
         If ( r6 .NE. zero ) w = Log ( Abs ( r6 ) )/albeta
         If ( prall ) Print  1021, r6, ibeta, w, x1
         w =  Max ( ait + w, zero )
         If ( prall ) Print 1022, ibeta, w
         w = -999.0D0
         If ( r7 .NE. zero ) w = Log ( Abs ( r7 ) )/albeta
         If ( prall ) Print 1023, r7, ibeta, w
         w =  Max ( ait + w, zero )
         If ( prall ) Print 1022, ibeta, w
         Call summ ( char(j), j, r6, r7, a, b, dummy, dummy, x1,
     &               dummy )
         If ( j .NE.  2 ) Go To  300
         b = alxmax
         a = three
  300    Continue
      End Do
      If ( prall ) Print 1100 
      Return
c-----------------------------------------------------------------
 1000 Format ( '1Test of Sinh(x) vs T.S. expansion of Sinh(x) '//)
 1001 Format ( '1Test of Sinh(x) vs c*(Sinh(x+1)+Sinh(x-1))   '//)
 1005 Format ( '1Test of Cosh(x) vs T.S. expansion of Cosh(x) '//)
 1006 Format ( '1Test of Cosh(x) vs c*(cosh(x+1)+Cosh(x-1))   '//)
 1010 Format ( I7,' Random arguments were tested from the',
     &         ' interval '/ 6X,'(',E15.4,',',E15.4,')'// )
 1011 Format ( ' Sinh(x) was larger',I6,' times,' /
     &     12X,' agreed',I6,' times, and '/
     &   8X,'was smaller',I6,' times.'// )
 1012 Format ( ' COSH(X) was larger',I6,' times,' /
     &     12X,' agreed',I6,' times, and '/
     &   8X,'was smaller',I6,' times.'// )
 1020 Format ( ' There are',I4,' base',I4,
     &    ' significant digits in a floating-point number  '//)
 1021 Format ( ' The maximum relative error of',E15.4,' = ',I4,
     & ' **', F7.2/4X,'occurred for X =',E17.6 )
 1022 Format ( ' The estimated loss of base',I4,
     &  ' significant digits is',F7.2// )
 1023 Format ( ' The root mean square relative error was',E15.4,
     &    ' = ',I4,' **',F7.2 )
 1100 Format ( ' This concludes the tests ')
c-----------------------------------------------------------------
      End
