      Subroutine sexp
      Implicit None
      External dran1, summ
      Common /blmaco/ ibeta, idum, it, irnd, minexp, maxexp, xmin, xmax
      Common /blprnt/ prall, iout, n
      Logical prall
c
c --- Program to test Exp
c
c
c --- Data required:
c
c        None
c
c --- Subprograms required from this package:
c
c                 IBETA         - The radix of the floating-point
c                                 system.
c                 IT            - The number of base-ibeta digits in
c                                 the significand of a floating-point
c                                 number.
c                 IRND          - 0 if floating-point addition chops,
c                                 1 if floating-point addition rounds.
c                 dran1( idum ) - A function subprogram returning
c                                 random _REAL_ numbers uniformly             
c                                 distributed over (0,1)
c
c --- Standard FORTRAN subprograms required:
c
c         Abs, Acos,  Log,  Log10,  Max , Asin,  Dble, Int, Sqrt
c
c
c --- Latest revision - December 6, 1979
c
c --- Author - W. J. Cody
c              Argonne National Laboratory
c
c ----------------------------------------------------------------------
      Integer          i, ibeta, iexp, iout, irnd, it, i1, j, k, k1,
     &                 k2, k3, l, m, machep, maxexp, minexp, n, negep,
     &                 ngrd, idum
      Double Precision a, ait, albeta, b, beta, d, del, one, dran1,
     &                 r6, r7, two, ten, v, w, x, xl, xmax, xmin ,xn,
     &                 x1, y, z, zero, zz, dummy
      Character*8      char(3)
c
      char(1) = 'Exp(x)'
      char(2) = 'Exp(x)'
      char(3) = 'Exp(x)'
c
      beta    =  Dble ( ibeta )
      albeta  =  Log ( beta )
      ait     =  Dble ( it )
      one     = 1.0D0
      two     = 2.0D0
      ten     = 10.0D0
      zero    = 0.0D0
      v       = 0.0625D0
      a       = two
      b       =  Log ( a ) * 0.5D0
      a       = -b + v
      d       =  Log( 0.9D0*xmax )
      xn      =  Dble( n )
      I1      = 0
c---------------------------------------------------------------------
c     Random argument accuracy tests.
c---------------------------------------------------------------------
      Do j = 1, 3
         k1 = 0
         k3 = 0
         x1 = zero
         r6 = zero
         r7 = zero
         del = (b - a) / xn
         xl = a
c
         Do i = 1, n
            X = DEL * dran1(IDUM) + XL
c---------------------------------------------------------------------
c     Purify arguments.
c---------------------------------------------------------------------
            y = x - v
            If ( Y .LT. zero )  x = y + v
            Z = Exp ( x ) 
            ZZ = Exp ( y ) 
            If ( j .EQ. 1 ) Go To  100
            If ( ibeta .NE. 10 ) z = z * .0625D0 -
     1           z * 2.44533210469205703894438669220964866D-3
            If ( ibeta .EQ. 10 ) z = z * 6.0D-2 +
     1           z * 5.46678953079429610556133077903513440D-5
            Go To  110
  100       z = z - z * 6.05869371865242138802891753776949155D-2
  110       w = one
            If ( zz .NE. zero )  w = ( z - zz ) / zz
            If ( w .LT. zero )  k1 = k1 + 1
            If ( W .GT. zero )  k3 = k3 + 1
            w = Abs ( w )
            If ( w .LE. r6 ) Go To  120
            r6 = w
            x1 = x
  120       r7 = r7 + w*w
            xl = xl + del
         End Do
c
         k2 = n - k3 - k1
         r7 = Sqrt ( r7 / xn )
         If ( prall ) Print  1000, v, v
         If ( prall ) Print  1010, n, a, b
         If ( prall ) Print  1011, k1, k2, k3
         If ( prall ) Print  1020, it,ibeta
         w = -999.0D0
         If ( r6 .NE. zero )  w =  Log ( Abs ( r6 ) )/albeta
         If ( prall ) Print  1021, r6, ibeta, w, x1
         w =  max ( ait + w, zero ) 
         If ( prall ) Print  1022, ibeta, w
         w = -999.0D0
         If ( r7 .NE. zero )  w =  Log ( Abs ( r7 ) )/albeta
         If ( prall ) Print  1023, r7, ibeta, w
         w =  max ( ait + w, zero )  
         If ( prall ) Print  1022, ibeta, w
         Call summ (char(j), j, r6, r7, a, b, dummy, dummy, x1,
     &              dummy )
         If ( j .EQ. 2 ) Go To  270
         v = 45.0D0 / 16.0D0
         a = -ten * b
         b = 4.0D0 * xmin * beta ** it
         b =  Log (b)
         Go To  300
  270    a = -two * a
         b = ten * a
         If ( b .LT. d ) b = d
  300    Continue
      End Do
      If ( prall ) Print  1100
      Return
c ----------------------------------------------------------------------
 1000 Format ( '1Test of Exp(x-',F7.4,') vs Exp ( x ) /Exp(',F7.4,')',
     &          // )
 1010 Format (  I7,' Random arguments were tested from the interval '/
     & 6X,'(',E15.4,',',E15.4,')'// )
 1011 Format ( ' Exp(x-v) was larger',I6,' times,' /
     &         13X,' agreed',I6,' times, and '/
     &   9X,'was smaller',I6,' times.'// )
 1020 Format ( ' There are',I4,' base',I4,
     1    ' significant digits in a floating-point number  '// )
 1021 Format ( ' The maximum relative error of',E15.4,' = ',I4,' **',
     1  F7.2/4X,'occurred for x =',E17.6 )
 1022 Format ( ' The estimated loss of base',I4,
     1  ' significant digits is',F7.2// )
 1023 Format ( ' The root mean square relative error was',E15.4,
     1    ' = ',I4,' **',F7.2 )
 1100 Format ( ' This concludes the tests ' )
c ----------------------------------------------------------------------
      End
