      Subroutine satan
      Implicit None
      External dran1, SUMM
      Common /blmaco/ ibeta, idum, it, irnd, minexp, maxexp, xmin, xmax
      Common /blprnt/ prall, iout, n
      Logical prall
c
c --- Program to test Asin/Acos
c
c --- Data required:
c
c        None
c
c --- Subprograms required from this package:
c
c                 IBETA         - The radix of the floating-point
c                                 system.
c                 IT            - The number of base-ibeta digits in
c                                 the significand of a floating-point
c                                 number.
c                 IRND          - 0 if floating-point addition chops,
c                                 1 if floating-point addition rounds.
c                 dran1( idum ) - A function subprogram returning
c                                 random _REAL_ numbers uniformly             
c                                 distributed over (0,1)
c
c --- Standard FORTRAN subprograms required:
c
c         Abs,  Log,  Max , Atan, Atan2,  Dble, Sqrt
c
c
c
c --- Latest revision - December 6, 1979
c
c --- Author - W. J. Cody
c              Argonne National Laboratory
c
c ----------------------------------------------------------------------
      Integer          i, ibeta, iexp, ii, iout, irnd, it, i1, j, k, k1,
     &                 k2, k3, l, m, machep, maxexp, minexp, n, negep,
     &                 ngrd, idum
      Double Precision a, ait, albeta, b, beta, betap, del, em, expon,
     &                 half, ob32, one, dran1, r6, r7, sum, two, w, x, 
     &                 xl, xmax, xmin, xn, xsq, x1, y, z, zero, zz,
     &                 dummy
      Character*8      char(4)
c
      char(1) = 'Atan(X)'
      char(2) = 'Atan(X)'
      char(3) = 'Atan(X)'
      char(4) = 'Atan(X)'
c
      beta    =  Dble(IBETA)
      albeta  =  LOG(BETA)
      ait     =  Dble(IT)
      one     = 1.0D0
      half    = 0.5D0
      two     = 2.0D0
      zero    = 0.0D0
      a       = -0.0625D0
      b       = -a
      ob32    = b * half
      xn      =  Dble ( n )
      i1      = 0
c-----------------------------------------------------------------
c     Random argument accuracy tests.
c-----------------------------------------------------------------
      Do j = 1, 4
         k1 = 0
         k3 = 0
         x1 = zero
         r6 = zero
         r7 = zero
         del = (b - a) / xn
         xl = a
c
         Do i = 1, n
            x = del * dran1 ( idum ) + xl
            If ( J .EQ. 2 ) x = ( ( 1.0D0 + X*A )- ONE )*
     &                          16.0D0
            z = Atan ( x )
            If ( j .NE. 1 ) Go To  100
            xsq = x * x
            em = 29.0D0
            sum = xsq / em
c
            Do ii = 1, 13
               em = em - two
               sum = ( one/em - sum ) * xsq
            End Do
c
            sum = -x * sum
            zz = x + sum
            sum = ( x - zz ) + sum
            If ( irnd .EQ. 0 ) zz = zz + ( sum + sum )
            Go To  110
  100       If ( j .NE. 2 ) Go To  105
            y = x - .0625D0
            y = y / ( one + x*a )
            zz = (Atan ( y )
     &            - 8.11900040426515260208870144948863937D-5)
     &            + ob32
            zz = zz + ob32
            Go To  110
  105       z = z + z
            y = x / ( ( half + x * half )*( (half - x) + half ) )
            zz = Atan ( y )
  110       w = one
            If ( z .NE. zero ) w = ( z - zz ) / z
            If ( W .GT. zero ) k1 = k1 + 1
            If ( W .LT. zero ) k3 = k3 + 1
            w = Abs ( w )
            If ( w .LE. r6 ) Go To  120
            r6 = w
            x1 = x
  120       r7 = r7 + w * w
            xl = xl + del
         End Do
c
         k2 = n - k3 - k1
         r7 = Sqrt ( r7 / xn )
         If ( j .EQ. 1 .AND. prall ) Print 1000 
         If ( j .EQ. 2 .AND. prall ) Print 1001 
         If ( j .GT. 2 .AND. prall ) Print 1002 
         If ( prall ) Print 1010, n, a, b
         If ( prall ) Print 1011, k1, k2, k3
         If ( prall ) Print 1020, it, ibeta
         w = -999.0D0
         If ( R6 .NE. zero ) w =  Log (Abs ( r6 ) )/albeta
         If ( prall ) Print 1021, r6, ibeta, w, x1
         w =  Max ( ait + w  ,zero )
         If ( prall ) Print 1022, ibeta, w
         w = -999.0D0
         If ( R7 .NE. ZERO ) w =  Log (Abs ( r7 ) )/albeta
         If ( prall ) Print 1023, r7, ibeta, w
         w =  Max ( ait + w  ,zero )
         If ( prall ) Print 1022, ibeta, w
         Call summ ( char(j), j, r6, r7, a, b, dummy, dummy, x1,
     &               dummy )
         a = b
         If ( j .EQ. 1 ) b = two - Sqrt ( 3.0D0 )
         If ( j .EQ. 2 ) B = Sqrt ( two ) - one
         If ( j .EQ. 3 ) B = one
      End Do
      If ( prall ) Print 1100 
      Return
c ----------------------------------------------------------------------
 1000 Format ( '1Test of Atan(x) vs truncated Taylor series  '// )
 1001 Format ( '1Test of Atan(x) vs ',
     &  'Atan(1/16) + Atan((x-1/16)/(1+x/16))    '// )
 1002 Format ( '1Test of 2*Atan(x) vs Atan(2X/(1-x*x))    '// )
 1010 Format ( I7,' Random arguments were tested from the interval '/
     & 6X,'(',E15.4,',',E15.4,')'// )
 1011 Format ( ' Atan(x) was larger',I6,' times,'/
     &    12X,' agreed',I6,' times, and '/
     &   8X,'was smaller',I6,' times.'// )
 1020 Format ( ' There are',I4,' base',I4,
     &    ' significant digits in a floating-point number  '// )
 1021 Format ( ' The maximum relative error of',E15.4,' = ',I4,' **',
     &  F7.2/4X,'occurred for X =',E17.6 )
 1022 Format ( ' The estimated loss of base',I4,
     &  ' significant digits is',F7.2// )
 1023 Format ( ' The root mean square relative error was',E15.4,
     &    ' = ',I4,' **',F7.2 )
 1100 Format ( ' This concludes the tests ' )
c ----------------------------------------------------------------------
      End
