      Double Precision Function randl ( x )
      Implicit         None
      Double Precision x
c
c --- Returns pseudo random numbers logarithmically distributed
c     over (1,exp(x)).  Thus a*randl(ln(b/a)) is logarithmically
c     distributed in (a,b).
c
c --- Other subroutines required:
c
c        Exp ( x )      - The exponential function.
c
c        dran1 ( idum ) - A function returning random Double Precision       
c                 numbers uniformly distributed over (0,1).
c                 the argument "idum" is a dummy.
c ---------------------------------------------------------------------
c
      Double Precision dran1, exp
      External         dran1
      Integer          idum
      Save             idum
      Data             idum/ -1989 /
c
      randl = Exp (x*dran1 ( idum ) )
c ---------------------------------------------------------------------
      Return
      End
