      Subroutine getInput( inc, maxinc, minc )
! ----------------------------------------------------------------------
! --- Reads cases to be done by program 'mod1d' and determines the
!     actual number of cases. 
!     Alerts when more than 'maxinc' cases are given in the input file.
! ----------------------------------------------------------------------
      Implicit    None

      Integer  :: maxinc, minc
      Integer  :: inc(maxinc)

      Integer  :: ninc = 1
! ----------------------------------------------------------------------
! --- Open input file.

      Open( 1, File = 'mod1d.in' )
      Do
         Read( 1, *, End = 10 ) inc(ninc)
         ninc = ninc + 1
         If ( ninc > maxinc ) Then
            Print *, ' Too many input values: increase maxinc in',
     &               ' program mod1d.'
            Stop
         End If
      End Do
   10 minc = ninc - 1
! ----------------------------------------------------------------------
      End Subroutine getInput         
