      Program mod2i
! ---------------------------------------------------------------------
!     Program 'mod2i' tests an iterative Quicksort algorithm with 
!     Integer and 8-byte Real data. Data are generated internally
!     by the Fortran 90-provided random generator.
! ---------------------------------------------------------------------
      Use                       numerics
      Use                       dist_module
      Implicit                  None
     
      Integer, Allocatable   :: idata(:), src(:)
      Real(l_),  Allocatable :: ddata(:)
      Real(l_)               :: cor, dlog2, speed1, speed2, time1,
     &                          time2, wclock
      Integer                :: i, k, m, me, n, nops, nrep, nl, nu
      Integer                :: omp_get_num_threads, omp_get_thread_num
      Logical                :: ok1, ok2
! ----------------------------------------------------------------------
      Call state( 'mod2i   ' )
      Open( 1, File = 'mod2i.in' )
!$omp parallel
      nodes = omp_get_num_threads()
!$omp end parallel
      Print 1000, nodes
   10 Read( 1, *, End = 20 ) n, nrep
      Call evdist( n )
      Allocate( idata(n), ddata(n), src(n) )
      Call ranint( 1, n, n, src )
      nops  = Int( n*dlog2( n ) )         ! --- Average work estimate!!

      time1 = wclock()                    ! --- Integer sort.
      Do i = 1, nrep
         idata = src
!$omp parallel private( me, m, nl, nu )
         me = omp_get_thread_num()
         m  = sizes(me)
         nl = offset(me)
         nu = offset(me+1) - 1
         Call iqsort( idata, m, nl, nu )
!$omp end parallel
         If ( nodes > 1 ) Call i_merge( n, nodes, n, idata, offset )
      End Do
      time1 = wclock() - time1
      ok1 = .TRUE.                        ! --- Correctness check.
      Call icheck( idata, n, ok1 )    
      time2 = wclock()                    ! --- 8-byte Real sort.
      Do i = 1, nrep
         ddata = Real( src, l_ )
!$omp parallel private( me, m, nl, nu )
         me = omp_get_thread_num()
         m  = sizes(me)
         nl = offset(me)
         nu = offset(me+1) - 1
         Call dqsort( ddata, m, nl, nu )
!$omp end parallel
         If ( nodes > 1 ) Call d_merge( n, nodes, n, ddata, offset )
      End Do  
      time2 = wclock() - time2
      ok2 = .TRUE.                        ! --- Correctness check.
      Call dcheck( ddata, n, ok2 )
      cor = wclock()                      ! --- Correct timings.
      Do i = 1, nrep
         idata = src
      End Do
      time1 = time1 - wclock() + cor
      cor = wclock()
      Do i = 1, nrep
         ddata = Real( src, l_ )
      End Do
      time2 = time2 - wclock() + cor
      
      speed1 = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time1, 1.0e-9_l_ )
      speed2 = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time2, 1.0e-9_l_ )
      
      Print 1010, n, time1/nrep, speed1, ok1, time2/nrep, speed2, ok2  
      Deallocate( idata, ddata , src )
      Go To 10
   20 Print 1020
! ---------------------------------------------------------------------
 1000 Format( 'Quicksort test: No. of procs. = ', i3/
     &        '-------------------------------------------------------',
     &        '----------------'/,
     &        '  Order |  Integer   |  Integer  |     |   Double   |',
     &        '  Double   |     |'/,
     &        '    n   |  Time (s)  |  (Mop/s)  | OK? |  Time (s)  |',
     &        '  (Mop/s)  | OK? |'/,
     &        '-------------------------------------------------------',
     &        '----------------' )
 1010 Format( I7,' |', G11.4,' |', G11.4, '|', L3,'  |', G11.4,
     &        ' |', G11.4, '|', L3, '  |' )
 1020 Format( '-------------------------------------------------------',
     &        '----------------' )
c ----------------------------------------------------------------------
      End Program mod2i
