      Subroutine evdist( n )
! ----------------------------------------------------------------------
! --- Routine 'evdist' distributes 'n' elements as evenly as possible
!     over 'nodes' processors. The actual number of elements per
!     processor are returned in array 'sizes'.
! --- Also the base addresses for the distribution of a global 1-D
!     array are computed and stored in array 'offset'.
! ----------------------------------------------------------------------
! --- Input: - Integer n
!            - Integer nodes              (via Module dist_module).
! --- Inout: - Integer sizes(0:maxnod-1)  (via Module dist_module).
! --- Inout: - Integer offset(0:maxnod)   (via Module dist_module).
! ----------------------------------------------------------------------
      Use        dist_module
      Integer :: n

      Integer :: i, non, nrest, rest
! ----------------------------------------------------------------------
      non   = n/nodes
      rest  = Mod( n, nodes )
      nrest = nodes - rest - 1
      Do i = 0, nodes - 1                    ! --- Set sizes.
         sizes(i) = non
         If ( i > nrest ) sizes(i) = non + 1
      End Do
      offset(0) = 1                          ! --- Set base addresses.
      offset(nodes) = n + 1                  ! --- Last element is a
      Do i = 1, nodes - 1                    ! --- sentinel for merging.
         offset(i) = offset(i-1) + sizes(i - 1)
      End Do
! ---------------------------------------------------------------------
      End Subroutine evdist
