      Subroutine check( a, n, ok, nprocs )
! ---------------------------------------------------------------------
! --- Routine 'check' checks the correctness of the parallelly
!     generated random numbers by comparing them to a small sample
!     of the sequentially generated numbers.
! ---------------------------------------------------------------------
      Use                      numerics
      Use                      ran_module
      Implicit                 None

      Integer               :: n, nprocs
      Real(l_)              :: a(n)
      Logical               :: ok

      Real(l_), Allocatable :: testar(:)
      Real(l_)              :: dran0, eps
      Integer               :: i
      Integer(8)            :: x1, x2
! ---------------------------------------------------------------------
      eps = 10.0_l_*Epsilon( 1.0_l_ )
      Allocate( testar(2*nprocs) )
      x1 = 2003
      x2 = 2017
      Do i = 1, 97
         x1 = Mod( a1*x1 + c1, m1 )
         x2 = Mod( a2*x2 + c2, m2 )
      End Do
      Do i = 1, 2*nprocs
         testar(i) = dran0( x1, x2 )
      End Do
      Do i = nprocs+1, 2*nprocs
            ok = ok .AND. ( Abs( testar(i) - a(i) ) <= eps )
      End Do
      Deallocate( testar )
! ---------------------------------------------------------------------
      End Subroutine check

