      Program mod2g
! ----------------------------------------------------------------------
! --- Purpose of the program
!     ----------------------
!     This program performs 2-D Haar wavelet transforms as used in data
!     compression. Data are generated internally and, subsequently, a
!     wavelet analysis and sythesis are performed. The time and Mflop/s
!     for an analysis/synthesis pair are determined.
! ----------------------------------------------------------------------
      Use                      numerics
      Implicit                 None
      Real(l_), Allocatable :: a1(:,:), a2(:,:), w1(:,:), w2(:,:)
      Real(l_)              :: speed, time1, wclock
      Integer               :: i, n1, n2, nops, nrep
      Integer               :: nprocs, omp_get_num_threads
      Logical               :: ok
! ----------------------------------------------------------------------
      Call state( 'mod2g   ' )
!$omp parallel shared(nprocs)
      nprocs = omp_get_num_threads()
!$omp end parallel
      Open( 1, File = 'mod2g.in' )
      Print 1000, nprocs
   10 Read( 1, *, End = 20 ) n1, n2, nrep
      Allocate( a1(n1,n2), a2(n2,n1), w1(n1,n2), w2(n2,n1) )
      nops = 5*(n2*(n1 - 1) + n1*(n2 - 1))
      Call gendat( a1, n1, n2 )
      time1 = wclock()
      Do i = 1, nrep
         Call anhr2d( a1, a2, w1, w2, n1, n2 )
         Call synhr2d( a1, a2, w1, w2, n1, n2 )
      End Do
      time1 = wclock() - time1
      speed = ( 1.0e-6_l_*nops )*nrep/Max( time1, 1.0e-9_l_ )
      Call gendat( w1, n1, n2 )
      ok = .TRUE.
      Call check( w1, a1, n1, n2, ok )
      Print 1010, n1, n2, time1/nrep, speed, ok    
      Deallocate( a1, a2, w1, w2 )
      Go To 10
   20 Print 1020
! ----------------------------------------------------------------------
 1000 Format( '2-D Haar wavelet transform test: No. of procs = ', i3 /
     &        '-------------------------------------------------------'/
     &        '    Order   | Exec. Time  |    Speed    | Correctness |'/
     &        '  n1 |  n2  |     (s)     |  (Mflop/s)  |      OK     |'/
     &        '-------------------------------------------------------'
     &         )
 1010 Format( I4,' | ',  I4,' |', G12.5,' |', G13.5, '|    ', L3,
     &        '      |' )
 1020 Format( '-------------------------------------------------------'
     &         )
! ----------------------------------------------------------------------
      End Program mod2g
