      Subroutine twiddle( arr, ari, m, n )
! ---------------------------------------------------------------------
! --- 'twiddle' does a complex multiplication with the appropriate
!     twiddle factors for the elements of 'arr' & 'ari' which represent
!     the Real and Imaginary parts of a 1-D 'm*(n*nodes)' length FFT, 
!     factored as a sequence of 'n*nodes' FFTs of length 'm'. 'nodes'
!     is the number of processors over which the 'm'-length FFTs are
!     distributed.
! ---------------------------------------------------------------------
      Use              numerics
      Implicit         None

      Integer       :: m, n
      Real(l_)      :: arr(0:m-1,0:n-1), ari(0:m-1,0:n-1)

      Integer       :: i, j
      Real(l_)      :: arg, fac, fr, fi, temp
! ---------------------------------------------------------------------
      fac   = 8.0_l_ * Atan( 1.0_l_ ) / ( m*n )
!$omp parallel do private(i,j,arg,fr,fi,temp)
      Do j = 0, n - 1
         Do i = 0, m - 1
            arg      = Real( i*j, l_ )*fac
            fr       = Cos( arg )
            fi       = Sin( arg )
            temp     = arr(i,j)*fr - ari(i,j)*fi
            ari(i,j) = arr(i,j)*fi + ari(i,j)*fr
            arr(i,j) = temp
         End Do
      End Do
! ---------------------------------------------------------------------
      End Subroutine twiddle
