      Subroutine gendat( arr, ari, m, n )
! ----------------------------------------------------------------------
! --- Routine 'gendat' generates the test data for the FFT:
!     one complete cosine cycle in the Real part of the data.
!     Zero in the imaginary part of the data.
! ----------------------------------------------------------------------
      Use              numerics
      Implicit         None

      Integer       :: m, n
      Real(l_)      :: arr(0:m-1,0:n-1), ari(0:m-1,0:n-1)

      Integer       :: i, j
      Real(l_)      :: arg, fac
! ----------------------------------------------------------------------
      fac   = 8.0_l_*Atan( 1.0_l_ )/( 1.0_l_*m*n )
      Do i = 0, n - 1
         Do j = 0, m - 1
            arg      = ( i*m + j )*fac
            arr(j,i) = Cos( arg )
            ari(j,i) = 0.0_l_
         End Do
      End Do
! ----------------------------------------------------------------------
      End Subroutine gendat 
